package com.pcloud.common.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author peidawei
 * @version 1.0.0
 * @package com.pcloud.common.entity
 * @className BasePageRequestVO
 * @description 分页请求VO基类
 * @date 2018年11月29日 下午 14:46
 */
@ApiModel("分页请求VO基类")
public class BasePageRequestVO implements Serializable {
    private static final long serialVersionUID = -4034188768789093041L;

    @ApiModelProperty(hidden = true)
    private Long userId;

    @ApiModelProperty("每页多少条")
    private Integer numPerPage;

    @ApiModelProperty("当前页")
    private Integer currentPage;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }
}
