package com.pcloud.common.utils;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.UUIDUitl;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.string.StringUtil;

/**
 * @描述：redis业务实现层
 * @作者：xiongfeng
 * @创建时间：2016年6月3日,下午9:25:33 @版本：1.0
 * 
 *                           modify by songx at 2017-05-17 redis存储修改为集群方式
 */
public abstract class SessionUtil {

	/**
	 * uuId长度
	 */
	public static final int LENGTH = 32;

	/**
	 * 用户id
	 */
	public static final String USER_ID = "userId";

	/**
	 * 系统id
	 */
	public static final String SYSTEM_ID = "systemId";

	/**
	 * 系统编码
	 */
	public static final String SYSTEM_CODE = "systemCode";

	/**
	 * 租户id
	 */
	public static final String TENANT_ID = "tenantId";

	/**
	 * 当事人id
	 */
	public static final String PARTY_ID = "partyId";

	/**
	 * 权限编码列表
	 */
	public static final String PERMISSION_CODE = "permissionCode";

	/**
	 * 权限列表
	 */
	public static final String PERMISSIONS = "permissions";

	/**
	 * 是否系统用户
	 */
	public static final String IS_SYSTEM = "isSystem";

	/**
	 * 角色编码
	 */
	public static final String ROLE_CODE = "roleCode";

	/**
	 * wechatUserId
	 */
	public static final String WECHAT_USER_ID = "wechatUserId";

	/**
	 * 讲师Id
	 */
	public static final String LECTURER_ID = "lecturerId";

	/**
	 * wechatUserId
	 */
	public static final String THIRD_TYPE = "thirdType";

	/**
	 * 登录场景
	 */
	public static final String MERCHANT_MEMBER_ID = "merchantMemberId";
	public static final String AGENT_MEMBER_ID = "agentMemberId";
	public static final String MEMBER_ID = "memberId";
	/**
	 * 登录场景
	 */
	public static final String CLIENT_CODE = "clientCode";

	/**
	 * 登录场景
	 */
	public static final Integer CLIENT_CODE_APP = 3;
	public static final Integer CLIENT_CODE_XCX = 4;
	public static final Integer CLIENT_CODE_SAYS = 5;

	/**
	 * token存redis默认时间(2个小时)
	 */
	private static final Integer DEFAULT_SESSION_TIMEOUT = 2 * 60 * 60;
	private static final Integer DEFAULT_SESSION_TIMEOUT_XCX = 15 * 24 * 60 * 60;

	/**
	 * token写入redis
	 * 
	 * @param map
	 * @return
	 */
	public static String writeToken2Redis(Map<String, Object> map) {
		// 生成用户token
		String token = UUIDUitl.generateString(LENGTH);
		Integer timeOut = DEFAULT_SESSION_TIMEOUT;
		if (map != null && (CLIENT_CODE_APP.equals(map.get(CLIENT_CODE)) || CLIENT_CODE_XCX.equals(map.get(CLIENT_CODE))
				|| CLIENT_CODE_SAYS.equals(map.get(CLIENT_CODE)))) {
			timeOut = DEFAULT_SESSION_TIMEOUT_XCX;
		}
		JedisClusterUtils.setObject(token, map, timeOut);
		return token;
	}

	/**
	 * 从redis删除token
	 * 
	 * @param token
	 */
	public static void deleteToken4Redis(String token) {
		JedisClusterUtils.delObject(token);
	}

	/**
	 * 从redis获取token
	 * 
	 * @param token
	 * @return
	 * @throws PermissionException
	 */
	public static Map<String, Object> getToken4Redis(String token) throws PermissionException {
		if (StringUtil.isEmpty(token)) {
			throw PermissionException.PERMISSION_USER_NOT_LOGIN;
		}
		Map<String, Object> map = JedisClusterUtils.getMap(token, String.class, Object.class);
		if (MapUtils.isEmpty(map)) {
			throw PermissionException.PERMISSION_TOKEN_EXPIRE;
		}
		Integer timeOut = DEFAULT_SESSION_TIMEOUT;
		if (map != null && (CLIENT_CODE_APP.equals(map.get(CLIENT_CODE)) || CLIENT_CODE_XCX.equals(map.get(CLIENT_CODE))
				|| CLIENT_CODE_SAYS.equals(map.get(CLIENT_CODE)))) {
			timeOut = DEFAULT_SESSION_TIMEOUT_XCX;
		}
		JedisClusterUtils.expireObject(token, timeOut);
		return map;
	}

	/**
	 * 从redis获取token 用户登录getinfo
	 * 
	 * @param token
	 * @return
	 * @throws PermissionException
	 */
	public static Map<String, Object> getInfoToken4Redis(String token) throws PermissionException {
		if (StringUtil.isEmpty(token)) {
			throw PermissionException.PERMISSION_USER_NOT_LOGIN;
		}
		Map<String, Object> map = JedisClusterUtils.getMap(token, String.class, Object.class);
		Integer timeOut = DEFAULT_SESSION_TIMEOUT;
		if (map != null && (CLIENT_CODE_APP.equals(map.get(CLIENT_CODE)) || CLIENT_CODE_XCX.equals(map.get(CLIENT_CODE))
				|| CLIENT_CODE_SAYS.equals(map.get(CLIENT_CODE)))) {
			timeOut = DEFAULT_SESSION_TIMEOUT_XCX;
		}
		JedisClusterUtils.expireObject(token, timeOut);
		return map;
	}

	/**
	 * 获取token中具体的值
	 * 
	 * @param token
	 * @return
	 * @throws PermissionException
	 */
	public static Object getVlaue(String token, String key) throws PermissionException {
		if (StringUtil.isEmpty(token)) {
			throw PermissionException.PERMISSION_USER_NOT_LOGIN;
		}
		Map<String, Object> map = JedisClusterUtils.getMap(token, String.class, Object.class);
		if (MapUtils.isEmpty(map)) {
			throw PermissionException.PERMISSION_TOKEN_EXPIRE;
		}
		Integer timeOut = DEFAULT_SESSION_TIMEOUT;
		if (map != null && (CLIENT_CODE_APP.equals(map.get(CLIENT_CODE)) || CLIENT_CODE_XCX.equals(map.get(CLIENT_CODE))
				|| CLIENT_CODE_SAYS.equals(map.get(CLIENT_CODE)))) {
			timeOut = DEFAULT_SESSION_TIMEOUT_XCX;
		}
		JedisClusterUtils.expireObject(token, timeOut);
		Object o = map.get(key);
		if (o == null) {
			throw PermissionException.PERMISSION_USER_NOT_LOGIN;
		}
		return o;
	}

}
