package com.pcloud.book.keywords.vo;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/25 10:28
 */
@ApiModel
public class ListKeywordParam implements Serializable {

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer numPerPage;

    @ApiModelProperty("关键词")
    private String keywords;

    @ApiModelProperty("社群码标识")
    private Long bookGroupId;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    @Override
    public String toString() {
        return "ListKeywordParam{" +
                "currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                ", keywords='" + keywords + '\'' +
                ", bookGroupId=" + bookGroupId +
                ", classifyId=" + classifyId +
                '}';
    }
}
