package com.pcloud.book.reading.biz;

import com.pcloud.book.reading.dto.AssignGroupDTO;
import com.pcloud.book.reading.dto.ReadingActivityAdditionParamDTO;
import com.pcloud.book.reading.dto.ReadingActivityBaseParamDTO;
import com.pcloud.book.reading.dto.ReadingActivityDTO;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.wechatgroup.message.dto.AddWXGroupDTO;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;
import com.sdk.wxgroup.CollectionVO;
import com.sdk.wxgroup.ReceiptMoneyVO;

/**
 * @描述：共读活动
 * @作者：zhuyajie
 * @创建时间：17:43 2020/1/14
 * @版本：1.0
 */
public interface ReadingActivityBiz {

    /**
     * 收到转账
     * @param vo 转账信息
     */
    void receiveMoney(CollectionVO vo);
    /**
     * 创建
     * @param readingActivityBaseParamDTO
     */
    Long add(ReadingActivityBaseParamDTO readingActivityBaseParamDTO);

    /**
     * 修改
     * @param readingActivityBaseParamDTO
     */
    void update(ReadingActivityBaseParamDTO readingActivityBaseParamDTO);

    /**
     * 添加高级设置
     * @param readingActivityAdditionParamDTO
     */
    void updateAdditionSetting(ReadingActivityAdditionParamDTO readingActivityAdditionParamDTO);

    /**
     * 定时任务回调-发送消息
     * @param methodType
     * @param activityId
     */
    void sendQuartzMsg(String methodType, Long activityId);

    /**
     * 接收个人号关键词消息
     */
    public void receiveKeyWord(SendTextDTO sendTextDTO);

    /**
     * 根据小号获取对应wxgroup ip
     * @param altId
     * @return
     */
    String getIP(String altId);
    /**
     * 根据id查询
     * @param id
     * @return
     */
    ReadingActivityDTO getById(Long id);

    /**
     * 定时任务回调-打卡每日提醒
     * @param activityId
     */
    void sendClockRemind(Long activityId);

    /**
     * 分页查询活动
     */
    PageBeanNew<ReadingActivityDTO> getList(Integer currentPage, Integer numPerPage);

    /**
     * 分配群
     * @param assignGroupDTO
     */
    void assignGroup(AssignGroupDTO assignGroupDTO);

    /**
     * 活动用户进群
     * @param addWXGroupDTO
     */
    void activityUserJoinGroup(AddWXGroupDTO addWXGroupDTO);

    /**
     * 是否是入群关键词
     * @param sendTextDTO
     * @return
     */
    Boolean isKeyWord(SendTextDTO sendTextDTO);
}
