package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.keywords.entity.RobotSkill4H5;
import com.pcloud.book.skill.dao.PcloudSkillDao;
import com.pcloud.book.skill.entity.PcloudSkill;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudSkillDao")
public class PcloudSkillDaoImpl extends BaseDaoImpl<PcloudSkill> implements PcloudSkillDao {
    @Override
    public void updateSeqNum(Long id, Integer seqNum) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("seqNum",seqNum);
        super.getSqlSession().selectList(getStatement("updateSeqNum"), map);
    }

    @Override
    public Integer getMaxSeqNum() {
        return  super.getSqlSession().selectOne(getStatement("getMaxSeqNum"));
    }

    @Override
    public PcloudSkill getByRelSkillId(Integer relSkillId) {
        return  super.getSqlSession().selectOne(getStatement("getByRelSkillId"),relSkillId);
    }

    @Override
    public List<RobotSkill4H5> getSkillList4TimeController(Integer type, Long labelId, String wxUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("type",type);
        map.put("labelId",labelId);
        map.put("wxUserId",wxUserId);
        return super.getSqlSession().selectList(getStatement("getSkillList4TimeController"), map);
    }

    @Override
    public List<RobotSkill4H5> getSkillList4Activity(Integer type, Long labelId) {
        Map<String,Object> map=new HashMap<>();
        map.put("type",type);
        map.put("labelId",labelId);
        return super.getSqlSession().selectList(getStatement("getSkillList4Activity"), map);
    }

    @Override
    public List<RobotSkill4H5> getSkillList4Resource(Integer type, Long labelId) {
        Map<String,Object> map=new HashMap<>();
        map.put("type",type);
        map.put("labelId",labelId);
        return super.getSqlSession().selectList(getStatement("getSkillList4Resource"), map);
    }

    @Override
    public List<Long> getLabelList4Activity(Integer type) {
        return  super.getSqlSession().selectList(getStatement("getLabelList4Activity"), type);
    }

    @Override
    public List<Long> getLabelList4TimeController(Integer type) {
        return  super.getSqlSession().selectList(getStatement("getLabelList4TimeController"), type);
    }

    @Override
    public List<Long> getLabelList4Resource(Integer type) {
        return  super.getSqlSession().selectList(getStatement("getLabelList4Resource"), type);
    }

    @Override
    public PcloudSkill getByRelId(Integer relSkillId, Integer type) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("relSkillId", relSkillId);
        paramMap.put("type", type);
        return getSqlSession().selectOne(getStatement("getByRelId"), paramMap);
    }
}
