package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.BmRegisterItemDao;
import com.pcloud.book.advertising.entity.AdvertisingBmRegisterItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @描述：报名选项记录
 * @作者：zhuyajie
 * @创建时间：20:19 2019/6/27
 * @版本：1.0
 */
@Component("bmRegisterItemDao")
public class BmRegisterItemDaoImpl extends BaseDaoImpl<AdvertisingBmRegisterItem> implements BmRegisterItemDao {

    @Override
    public Integer checkMobilePhone(Long adId,String fromType, Long fromId, String optionValue) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("fromType", fromType);
        map.put("fromId",fromId);
        map.put("optionValue", optionValue);
        return getSessionTemplate().selectOne(getStatement("checkMobilePhone"), map);
    }

    @Override
    public Integer checkMobilePhone4Cpa(Long cpaId, String fromType, Long fromId, String optionValue) {
        Map<String, Object> map = new HashMap<>();
        map.put("cpaId", cpaId);
        map.put("fromType", fromType);
        map.put("fromId",fromId);
        map.put("optionValue", optionValue);
        return getSessionTemplate().selectOne(getStatement("checkMobilePhone4Cpa"), map);
    }
}
