package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletSubscribeCountBiz;
import com.pcloud.book.applet.biz.AppletSubscribeRecordBiz;
import com.pcloud.book.applet.dao.AppletSubscribeRecordDao;
import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.book.applet.entity.AppletSubscribeRecord;
import com.pcloud.book.applet.enums.SubscribeCountTypeEnum;
import com.pcloud.book.util.common.YesOrNoEnums;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * (AppletSubscribeRecord)表服务实现类
 *
 * @author wubo
 * @since 2021-08-03 09:37:01
 */
@Service("appletSubscribeRecordBiz")
public class AppletSubscribeRecordBizImpl implements AppletSubscribeRecordBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletSubscribeRecordBizImpl.class);

    @Autowired
    private AppletSubscribeRecordDao appletSubscribeRecordDao;
    @Autowired
    private AppletSubscribeCountBiz appletSubscribeCountBiz;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletSubscribeRecord getById(Long id) {
        return appletSubscribeRecordDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletSubscribeRecordDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    @Transactional(rollbackFor = Exception.class)
    public Long insert(AppletSubscribeRecord appletSubscribeRecord) {
        if (null == appletSubscribeRecord || null == appletSubscribeRecord.getRecordType()) {
           throw  new BizException(BizException.PARAM_IS_NULL.getCode(), "新增消息授权失败");
        }
        appletSubscribeRecordDao.insert(appletSubscribeRecord);
        //查询用户订阅次数
        Integer subscribeRecordCount = SubscribeCountTypeEnum.getCountByValue(appletSubscribeRecord.getCountType());
        AppletSubscribeCount subscribeCount = appletSubscribeCountBiz.getByUserId(appletSubscribeRecord.getWechatUserId(), appletSubscribeRecord.getRecordType());
        if (null == subscribeCount && subscribeRecordCount > 0) {
            subscribeCount = new AppletSubscribeCount();
            subscribeCount.setWechatUserId(appletSubscribeRecord.getWechatUserId());
            subscribeCount.setValidCount(YesOrNoEnums.YES.getValue());
            subscribeCount.setRecordType(appletSubscribeRecord.getRecordType());
            appletSubscribeCountBiz.insert(subscribeCount);
        } else if (null != subscribeCount){
            subscribeCount.setValidCount(subscribeCount.getValidCount() + subscribeRecordCount);
            if (subscribeCount.getValidCount() < 0) {
                subscribeCount.setValidCount(0);
            }
            appletSubscribeCountBiz.update(subscribeCount);
        }
        return appletSubscribeRecord.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletSubscribeRecord appletSubscribeRecord) {
        if (appletSubscribeRecord == null || !NumberUtil.isNumber(appletSubscribeRecord.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletSubscribeRecordDao.update(appletSubscribeRecord);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletSubscribeRecordDao.deleteById(id);
    }

    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
        appletSubscribeRecordDao.softDeleteById(id);
    }
}