package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 小睿小程序点击量统计(AppletRecordStatics)实体类
 *
 * @author makejava
 * @since 2020-12-10 16:08:46
 */
@Data
public class AppletRecordStatisDTO {

    @ApiModelProperty("主键id")
    private Long id;
    
    @ApiModelProperty("用户id")
    private Long wechatUserId;
    
    @ApiModelProperty("记录类型")
    private Integer recordType;
    
    @ApiModelProperty("应用/作品类型/资源类型")
    private String sourceType;

    @ApiModelProperty("应用/作品类型/资源类型")
    private String sourceTypeName;
    
    @ApiModelProperty("点击量")
    private Long clickCount;

    @ApiModelProperty("占比")
    private BigDecimal clickRatio = BigDecimal.ZERO;

    @ApiModelProperty("占比")
    private String strClickRatio;

    @ApiModelProperty("统计日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statisDate;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
