package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.dto.ThirdResourceRecordDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.pcloud.book.advertising.entity.AdvertisingLinkClick;
import com.pcloud.book.applet.biz.AppletThirdResourcesBiz;
import com.pcloud.book.applet.dto.AppletThirdResourcesDTO;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.book.applet.entity.AppletThirdResourcesClick;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.dto.ResourceOnBookDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.readercenter.wechat.exception.WechatUserException;
import com.pcloud.settlementcenter.account.enums.IsSystem;

import java.util.Map;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController("appletThirdResourcesFacade")
@RequestMapping("appletThirdResources")
public class AppletThirdResourcesFacade {

    @Autowired
    private AppletThirdResourcesBiz thirdResourcesBiz;

    @ApiOperation(value = "第三方资源埋点", httpMethod = "POST")
    @PostMapping(value = "addClickRecord")
    public ResponseDto<?> addClickRecord(@CookieValue("userInfo") String userInfo,
                @RequestBody @ApiParam  AppletThirdResourcesClick thirdResourcesClick) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        if (null == thirdResourcesClick || null == thirdResourcesClick.getThirdResourcesId() ) {
            throw new WechatUserException(WechatUserException.FIELD_IS_NULL, "缺失参数");
        }
        thirdResourcesClick.setWechatUserId(wechatUserId);
        thirdResourcesClick.setOfficialAccountsId(officialAccountsId);
        thirdResourcesBiz.addServiceRecord(thirdResourcesClick);
        return new ResponseDto<>();
    }

    @ApiOperation("获取第三方分析列表")
    @GetMapping("getListThirdResourcesAnalysis")
    public ResponseDto<?> getListThirdResourcesAnalysis(@RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "keyValue", required = false) @ApiParam("关键字") String keyValue,
            @RequestParam(value = "source", required = false) @ApiParam("来源") String source,
            @RequestParam(value = "resourcesType", required = false) @ApiParam("类型") String resourcesType,
            @RequestParam(value = "browseQty", required = false) @ApiParam("浏览量") Integer browseQty,
            @RequestParam(value = "clickQty", required = false) @ApiParam("点击量") Integer clickQty)
            throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);

        PageBeanNew<AppletThirdResourcesDTO> result = thirdResourcesBiz
                .getListThirdResourcesAnalysis(keyValue, source, resourcesType, browseQty, clickQty, currentPage,
                        numPerPage);
        return new ResponseDto<>(result);
    }

    @ApiOperation("获取第三方近一月趋势图数据")
    @GetMapping("getAnalysisDetail")
    public ResponseDto<?> getAnalysisDetail(@RequestHeader("token") String token,
            @RequestParam(value = "thirdResourcesId") @ApiParam("识别号") Long thirdResourcesId)
            throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);

        AppletThirdResourcesDTO result = thirdResourcesBiz.getAnalysisDetail(thirdResourcesId);
        return new ResponseDto<>(result);
    }

    @ApiOperation("获取咨询近一月趋势图数据")
    @GetMapping("getNewsTrendChart")
    public ResponseDto<?> getNewsTrendChart(@RequestHeader("token") String token,
            @RequestParam(value = "newsId") @ApiParam("咨询唯一识别号") Long newsId) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);

        AppletThirdResourcesDTO result = thirdResourcesBiz.getNewsTrendChart(newsId);
        return new ResponseDto<>(result);
    }

    @ApiOperation("查询第三方资源")
    @GetMapping("getThirdResources")
    public ResponseDto<?> getThirdResources(@RequestHeader("token") String token,
            @RequestParam(value = "type", required = false) @ApiParam("类型") Long type,
            @RequestParam(value = "source", required = false) @ApiParam("来源") String source,
            @RequestParam(value = "keyValue", required = false) @ApiParam("关键字") String keyValue,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少分页参数");
        }
        PageBeanNew<AppletThirdResources> pageBeanNew = thirdResourcesBiz
                .getThirdResources(type, source, keyValue, currentPage, numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation("删除第三方资源")
    @GetMapping("deleteThirdResources")
    public ResponseDto<?> deleteThirdResources(@RequestHeader("token") String token, @RequestParam("id") @ApiParam("id") Long id)
            throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        thirdResourcesBiz.deleteAppletsById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改第三方咨询信息")
    @PostMapping("updateThirdResources")
    public ResponseDto<?> updateThirdResources(@RequestHeader("token") String token,
            @RequestBody @ApiParam AppletThirdResourcesDTO thirdResourcesDTO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (thirdResourcesDTO != null && thirdResourcesDTO.getId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺失主键id");
        }
        thirdResourcesBiz.updateThirdResources(thirdResourcesDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id获取第三方资源信息")
    @GetMapping("getThirdResourcesById")
    public ResponseDto<?> getThirdResourcesById(@RequestHeader("token") String token,
            @RequestParam(value = "id", required = true) @ApiParam("第三方资源id") Long id
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);

        AppletThirdResources result = thirdResourcesBiz.getAppletsById(id);
        return new ResponseDto<>(result);
    }


    @ApiOperation("创建第三方资源")
    @PostMapping("createThirdResources")
    public ResponseDto<?> createThirdResources(@RequestHeader("token") String token,
            @RequestBody @ApiParam @Validated AppletThirdResourcesDTO thirdResourcesDTO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (thirdResourcesDTO != null && Long.compare(thirdResourcesDTO.getType(), 0) == 0
                && thirdResourcesDTO.getAppletsId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺失小程序id");
        }
        thirdResourcesBiz.createThirdResources(thirdResourcesDTO);
        return new ResponseDto<>();
    }

    @GetMapping("listThirdResourceRecord")
    public ResponseDto<PageBeanNew<ThirdResourceRecordDTO>> listThirdResourceRecord(@RequestHeader("token") String token,
                                                                                    @RequestParam(value = "thirdResourceId") Long thirdResourceId,
                                                                                    @RequestParam(value = "queryName",required = false) String queryName,
                                                                                    @RequestParam(value = "wechatUser",required = false) String wechatUser,
                                                                                    @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                                                    @RequestParam(value = "numPerPage", defaultValue = "1000") Integer numPerPage,
                                                                                    @RequestParam(value = "recordType", required = false) Integer recordType) {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<ThirdResourceRecordDTO> thirdResourceRecordDTOPageBeanNew  = thirdResourcesBiz.listThirdResourceRecord(queryName,currentPage, numPerPage, wechatUser, thirdResourceId, recordType);
        return new ResponseDto<>(thirdResourceRecordDTOPageBeanNew);
    }

    @ApiOperation("H5资源页-我的-为你推荐")
    @GetMapping("getThirdResourcesByGradeLabel4ResourcePage")
    public ResponseDto<?> getThirdResourcesByGradeLabel4ResourcePage(
            @RequestParam("gradeLabelId") Long gradeLabelId, @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage) {
        if (null == gradeLabelId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少用户年级标签");
        }
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少分页参数");
        }
        return new ResponseDto<>(thirdResourcesBiz.getThirdResourcesByGradeLabel4ResourcePage(gradeLabelId, currentPage, numPerPage));
    }

   @ApiOperation("根据编号查第三方资源")
   @GetMapping("getThirdResourceByNumber")
    public ResponseDto<?> getThirdResourceByNumber(@RequestHeader("token") String token, @RequestParam("number") String number) {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(thirdResourcesBiz.getThirdResourceByNumber(number));
    }


    @ApiOperation("第三方资源上书情况")
    @GetMapping("listThirdResourceOnBook")
    public ResponseDto<?> listThirdResourceOnBook(@RequestHeader("token") String token,
                                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                  @RequestParam(value = "numPerPage", defaultValue = "1000") Integer numPerPage,
                                                  @RequestParam("thirdResourceId") Long thirdResourceId) {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(thirdResourcesBiz.listThirdResourceOnBook(currentPage, numPerPage, thirdResourceId));
    }



    @ApiOperation("导出-第三方资源上书情况")
    @GetMapping("exportThirdResourceOnBook")
    public ResponseDto<?> exportThirdResourceOnBook(@RequestHeader("token") String token, @RequestParam("thirdResourceId") Long thirdResourceId) {
        Map<String,Object> map =  SessionUtil.getToken4Redis(token);
        String isSystem = (String)map.get(SessionUtil.IS_SYSTEM);
        Long pcloudId = (Long) map.get(SessionUtil.PARTY_ID);
        if (IsSystem.NOT_SYSTEM.code.equals(isSystem)){
            pcloudId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        thirdResourcesBiz.exportThirdResourceOnBook(thirdResourceId, pcloudId);
        return new ResponseDto<>();
    }
}