package com.pcloud.book.book.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.applet.biz.AppletGroupSearchRecordBiz;
import com.pcloud.book.applet.dto.AppletGroupStatementDTO;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookQrcodeWxworkBiz;
import com.pcloud.book.book.dao.BookQrcodeWxworkDao;
import com.pcloud.book.book.entity.BookQrcodeWxwork;
import com.pcloud.book.book.enums.BookQrcodeType;
import com.pcloud.book.book.enums.WxworkQrcodeType;
import com.pcloud.book.book.vo.request.BookQrcodeWxworkRequestVO;
import com.pcloud.book.book.vo.response.BookQrcodeWxworkResponseVO;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.erp.ErpConsr;
import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.WxworkQrcodeDTO;
import com.pcloud.book.group.vo.CrmContactQrcodeVO;
import com.pcloud.channelcenter.qrcode.dto.QrcodeSceneDto;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.wechatgroup.wxwork.dto.WxworkGroupQrcodeBaseDTO;
import com.pcloud.wechatgroup.wxwork.dto.WxworkQrcodeBaseDTO;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName com.pcloud.book.book.biz.impl.BookQrcodeWxworkBizImpl
 * @Author zhuyajie
 * @Description 二维码配置企业微信
 * @Date 2020/12/22 18:23
 * @Version 1.0
 **/
@Component
public class BookQrcodeWxworkBizImpl implements BookQrcodeWxworkBiz {

    @Autowired
    private BookQrcodeWxworkDao bookQrcodeWxworkDao;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private BookGroupDao bookGroupDao;
    @Autowired
    private WechatGroupConsr wechatGroupConsr;
    @Autowired
    private AppletGroupSearchRecordBiz appletGroupSearchRecordBiz;
    @Autowired
    private ErpConsr erpConsr;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void setWxworkQrcode(BookQrcodeWxworkRequestVO bookQrcodeWxworkRequestVO) {
        if (null == bookQrcodeWxworkRequestVO) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少参数");
        }
        if (null == bookQrcodeWxworkRequestVO.getSceneId() && null == bookQrcodeWxworkRequestVO.getBookGroupId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少二维码参数");
        }
        if (null == bookQrcodeWxworkRequestVO.getWxworkQrcodeType()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少企业微信二维码类型");
        }
        if (null != bookQrcodeWxworkRequestVO.getSceneId()) {
            bookQrcodeWxworkDao.deleteByQrcodeIdAndType(bookQrcodeWxworkRequestVO.getSceneId(), BookQrcodeType.OFFICIAL_ACCOUNTS.getCode(),
                    bookQrcodeWxworkRequestVO.getWxworkQrcodeType());
        } else {
            bookQrcodeWxworkDao.deleteByQrcodeIdAndType(bookQrcodeWxworkRequestVO.getBookGroupId(), BookQrcodeType.RAYS.getCode(),
                    bookQrcodeWxworkRequestVO.getWxworkQrcodeType());
        }
        if (null != bookQrcodeWxworkRequestVO.getWxworkQrcodeId()) {
            BookQrcodeWxwork bookQrcodeWxwork;
            if (null != bookQrcodeWxworkRequestVO.getSceneId()) {
                bookQrcodeWxwork = setSceneWxworkQrcode(bookQrcodeWxworkRequestVO.getSceneId());
            } else {
                bookQrcodeWxwork = setBookGroupWxWorkQrcode(bookQrcodeWxworkRequestVO.getBookGroupId());
            }
            bookQrcodeWxwork.setWxworkQrcodeId(bookQrcodeWxworkRequestVO.getWxworkQrcodeId());
            bookQrcodeWxwork.setWxworkQrcodeType(bookQrcodeWxworkRequestVO.getWxworkQrcodeType());
            bookQrcodeWxwork.setGuide(bookQrcodeWxworkRequestVO.getGuide());
            bookQrcodeWxworkDao.insert(bookQrcodeWxwork);
        }
    }

    private BookQrcodeWxwork setBookGroupWxWorkQrcode(Long bookGroupId) {
        BookQrcodeWxwork bookQrcodeWxwork = new BookQrcodeWxwork();
        BookGroupDTO bookGroupDTO = bookGroupDao.getDTOById(bookGroupId);
        if (null == bookGroupDTO) {
            throw new BookBizException(BookBizException.ERROR, "二维码不存在");
        }
        bookQrcodeWxwork.setBookId(bookGroupDTO.getBookId());
        bookQrcodeWxwork.setAdviserId(bookGroupDTO.getCreateUser());
        bookQrcodeWxwork.setChannelId(bookGroupDTO.getChannelId());
        bookQrcodeWxwork.setBookQrcodeId(bookGroupId);
        bookQrcodeWxwork.setBookQrcodeType(BookQrcodeType.RAYS.getCode());
        return bookQrcodeWxwork;
    }

    private BookQrcodeWxwork setSceneWxworkQrcode(Long sceneId) {
        BookQrcodeWxwork bookQrcodeWxwork = new BookQrcodeWxwork();
        QrcodeSceneDto qrcodeSceneDto = qrcodeSceneConsr.getById(sceneId);
        if (null == qrcodeSceneDto) {
            throw new BookBizException(BookBizException.ERROR, "二维码不存在");
        }
        bookQrcodeWxwork.setBookId(qrcodeSceneDto.getAdviserBookId());
        bookQrcodeWxwork.setAdviserId(qrcodeSceneDto.getCreatedByUserLogin());
        bookQrcodeWxwork.setChannelId(qrcodeSceneDto.getChannelPartyId());
        bookQrcodeWxwork.setBookQrcodeId(sceneId);
        bookQrcodeWxwork.setBookQrcodeType(BookQrcodeType.OFFICIAL_ACCOUNTS.getCode());
        return bookQrcodeWxwork;
    }

    @Override
    public Long getWxworkQrcodeIdBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType) {
        if (null == sceneId && null == bookGroupId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少参数");
        }
        BookQrcodeWxwork bookQrcodeWxwork;
        if (null != sceneId) {
            bookQrcodeWxwork = bookQrcodeWxworkDao.getByQrcodeIdAndType(sceneId, BookQrcodeType.OFFICIAL_ACCOUNTS.getCode(), wxworkQrcodeType);
        } else {
            bookQrcodeWxwork = bookQrcodeWxworkDao.getByQrcodeIdAndType(bookGroupId, BookQrcodeType.RAYS.getCode(), wxworkQrcodeType);
        }
        Long wxworkQrcodeId = null == bookQrcodeWxwork ? null : bookQrcodeWxwork.getWxworkQrcodeId();
        return wxworkQrcodeId;
    }

    @Override
    public BookQrcodeWxworkResponseVO getWxworkQrcodeInfoBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType) {
        BookQrcodeWxworkResponseVO bookQrcodeWxworkResponseVO = new BookQrcodeWxworkResponseVO();
        BookQrcodeWxwork bookQrcodeWxwork;
        if (null != sceneId) {
            bookQrcodeWxwork = bookQrcodeWxworkDao.getByQrcodeIdAndType(sceneId, BookQrcodeType.OFFICIAL_ACCOUNTS.getCode(), wxworkQrcodeType);
        } else {
            bookQrcodeWxwork = bookQrcodeWxworkDao.getByQrcodeIdAndType(bookGroupId, BookQrcodeType.RAYS.getCode(), wxworkQrcodeType);
        }
        if (null == bookQrcodeWxwork) {
            return bookQrcodeWxworkResponseVO;
        }
        Long wxworkQrcodeId = bookQrcodeWxwork.getWxworkQrcodeId();
        bookQrcodeWxworkResponseVO.setWxworkQrcodeId(wxworkQrcodeId);
        bookQrcodeWxworkResponseVO.setGuide(bookQrcodeWxwork.getGuide());
        if (WxworkQrcodeType.SOP_QRCODE.getCode().equals(wxworkQrcodeType)) {
            WxworkQrcodeBaseDTO wxworkQrcodeBaseDTO = wechatGroupConsr.getWxworkQrcodeBaseById(wxworkQrcodeId);
            if (null != wxworkQrcodeBaseDTO) {
                bookQrcodeWxworkResponseVO.setWxworkQrcodeUrl(wxworkQrcodeBaseDTO.getQrcodeUrl());
                bookQrcodeWxworkResponseVO.setWxworkQrcodeName(wxworkQrcodeBaseDTO.getQrcodeName());
                bookQrcodeWxworkResponseVO.setGuideAccounts(wxworkQrcodeBaseDTO.getGuideAccounts());
                bookQrcodeWxworkResponseVO.setGuideRays(wxworkQrcodeBaseDTO.getGuideRays());
            }
        } else if (WxworkQrcodeType.GROUP_QRCODE.getCode().equals(wxworkQrcodeType)) {
            WxworkGroupQrcodeBaseDTO groupQrcodeBaseDTO = wechatGroupConsr.getWxworkGroupQrcodeBaseById(wxworkQrcodeId);
            if (null != groupQrcodeBaseDTO){
                bookQrcodeWxworkResponseVO.setWxworkQrcodeUrl(groupQrcodeBaseDTO.getGroupQrcodeUrl());
                bookQrcodeWxworkResponseVO.setWxworkQrcodeName(groupQrcodeBaseDTO.getGroupQrcodeName());
                bookQrcodeWxworkResponseVO.setInvitationRays(groupQrcodeBaseDTO.getInvitationRays());
                bookQrcodeWxworkResponseVO.setInvitationAccounts(groupQrcodeBaseDTO.getInvitationAccounts());
            }
        } else if (WxworkQrcodeType.CRM_QRCODE.getCode().equals(wxworkQrcodeType)) {
            CrmContactQrcodeVO crmContactQrcodeVO = erpConsr.getContactQrcodeNameById4Adviser(wxworkQrcodeId);
            if (null != crmContactQrcodeVO) {
                bookQrcodeWxworkResponseVO.setWxworkQrcodeUrl(crmContactQrcodeVO.getQrcodeUrl());
                bookQrcodeWxworkResponseVO.setWxworkQrcodeName(crmContactQrcodeVO.getContactQrcodeName());
            }
        }
        return bookQrcodeWxworkResponseVO;
    }

    @Override
    public List<BookQrcodeWxworkResponseVO> getWxworkQrcodeInfoByBook4Rays(Long bookId, Long channelId, Long adviserId, Integer wxworkQrcodeType) {
        List<BookQrcodeWxworkResponseVO> wxworkResponseVOS = new ArrayList<>();
        List<BookQrcodeWxwork> wxworkList = bookQrcodeWxworkDao.getWxworkQrcodeByBook(bookId, channelId, adviserId, wxworkQrcodeType);
        if (ListUtils.isEmpty(wxworkList)) {
            return new ArrayList<>();
        }
        List<Long> wxworkQrcodeIds = new ArrayList<>();
        List<Long> wxworkGroupQrcodeIds = new ArrayList<>();
        for (BookQrcodeWxwork bookQrcodeWxwork : wxworkList) {
            if (WxworkQrcodeType.SOP_QRCODE.getCode().equals(bookQrcodeWxwork.getWxworkQrcodeType())) {
                wxworkQrcodeIds.add(bookQrcodeWxwork.getWxworkQrcodeId());
            } else if (WxworkQrcodeType.GROUP_QRCODE.getCode().equals(bookQrcodeWxwork.getWxworkQrcodeType())) {
                wxworkGroupQrcodeIds.add(bookQrcodeWxwork.getWxworkQrcodeId());
            }
        }
        Map<Long, WxworkQrcodeBaseDTO> wxworkQrcodeBaseDTOMap = new HashMap<>();
        Map<Long, WxworkGroupQrcodeBaseDTO> groupQrcodeBaseDTOMap = new HashMap<>();
        if (!ListUtils.isEmpty(wxworkQrcodeIds)) {
            wxworkQrcodeBaseDTOMap = wechatGroupConsr.mapWxworkQrcodeBase(wxworkQrcodeIds);
        }
        if (!ListUtils.isEmpty(wxworkGroupQrcodeIds)) {
            groupQrcodeBaseDTOMap = wechatGroupConsr.mapWxworkGroupQrcodeBase(wxworkGroupQrcodeIds);
        }
        for (BookQrcodeWxwork bookQrcodeWxwork : wxworkList) {
            if (!MapUtils.isEmpty(wxworkQrcodeBaseDTOMap) && WxworkQrcodeType.SOP_QRCODE.getCode().equals(bookQrcodeWxwork.getWxworkQrcodeType())) {
                WxworkQrcodeBaseDTO wxworkQrcodeBaseDTO = wxworkQrcodeBaseDTOMap.get(bookQrcodeWxwork.getWxworkQrcodeId());
                if (null != wxworkQrcodeBaseDTO) {
                    BookQrcodeWxworkResponseVO responseVO = new BookQrcodeWxworkResponseVO();
                    responseVO.setWxworkQrcodeId(bookQrcodeWxwork.getWxworkQrcodeId());
                    responseVO.setWxworkQrcodeType(bookQrcodeWxwork.getWxworkQrcodeType());
                    responseVO.setWxworkQrcodeUrl(wxworkQrcodeBaseDTO.getQrcodeUrl());
                    responseVO.setWxworkQrcodeName(wxworkQrcodeBaseDTO.getQrcodeName());
                    responseVO.setGuideAccounts(wxworkQrcodeBaseDTO.getGuideAccounts());
                    responseVO.setGuideRays(wxworkQrcodeBaseDTO.getGuideRays());
                    wxworkResponseVOS.add(responseVO);
                }
            }
            if (!MapUtils.isEmpty(groupQrcodeBaseDTOMap) && WxworkQrcodeType.GROUP_QRCODE.getCode().equals(bookQrcodeWxwork.getWxworkQrcodeType())) {
                WxworkGroupQrcodeBaseDTO wxworkGroupQrcodeBaseDTO = groupQrcodeBaseDTOMap.get(bookQrcodeWxwork.getWxworkQrcodeId());
                if (null != wxworkGroupQrcodeBaseDTO) {
                    BookQrcodeWxworkResponseVO responseVO = new BookQrcodeWxworkResponseVO();
                    responseVO.setWxworkQrcodeId(bookQrcodeWxwork.getWxworkQrcodeId());
                    responseVO.setWxworkQrcodeType(bookQrcodeWxwork.getWxworkQrcodeType());
                    responseVO.setWxworkQrcodeName(wxworkGroupQrcodeBaseDTO.getGroupQrcodeName());
                    responseVO.setInvitationAccounts(wxworkGroupQrcodeBaseDTO.getInvitationAccounts());
                    responseVO.setInvitationRays(wxworkGroupQrcodeBaseDTO.getInvitationRays());
                    //头像列表从缓存里取
                    List<String> headUrlList = appletGroupSearchRecordBiz
                            .getHeadUrlList(9, bookQrcodeWxwork.getWxworkQrcodeId());
                    responseVO.setHeadUrlList(headUrlList);
                    List<AppletGroupStatementDTO> statementDTOList = appletGroupSearchRecordBiz
                            .getStatementList(9, headUrlList, bookQrcodeWxwork.getWxworkQrcodeId());
                    responseVO.setStatementDTOList(statementDTOList);
                    wxworkResponseVOS.add(responseVO);
                }
            }
        }
        return wxworkResponseVOS;
    }

    @Override
    public List<Long> getWxworkGroupQrcodeIdsExceptBook(Long sceneId, Long bookGroupId) {
        if (null == sceneId && null == bookGroupId) {
            return new ArrayList<>();
        }
        Integer wxworkQrcodeType = WxworkQrcodeType.GROUP_QRCODE.getCode();
        Long bookId;
        if (null != sceneId) {
            QrcodeSceneDto qrcodeSceneDto = qrcodeSceneConsr.getById(sceneId);
            bookId = qrcodeSceneDto == null ? null : qrcodeSceneDto.getAdviserBookId();
        } else {
            BookGroupDTO bookGroupDTO = bookGroupDao.getBookBaseInfoById(bookGroupId);
            bookId = bookGroupDTO == null ? null : bookGroupDTO.getBookId();
        }
        if (null == bookId) {
            return new ArrayList<>();
        }
        List<Long> groupQrcodeIds = bookQrcodeWxworkDao.getWxworkQrcodeIdsExceptBook(bookId, wxworkQrcodeType);
        return groupQrcodeIds;
    }

    @Override
    public Map<Long, BookGroupServeCountDTO> mapWxWorkServeCount4SceneIds(List<Long> sceneIds, Integer bookQrcodeType) {
        if(CollUtil.isEmpty(sceneIds)){
            return new HashMap<>();
        }
        List<BookGroupServeCountDTO> list = bookQrcodeWxworkDao.mapWxWorkServeCount4SceneIds(sceneIds, bookQrcodeType);
        if(CollUtil.isEmpty(list)){
            return new HashMap<>();
        }
        Map<Long, BookGroupServeCountDTO> resultMap = list.stream().collect(Collectors.toMap(x -> x.getBookQrcodeId(), x -> x, (v1, v2) -> v2));
        return CollUtil.isEmpty(resultMap) ? new HashMap<>() : resultMap;
    }

    @Override
    public Map<String, BookGroupServeCountDTO> mapWxWorkServeCount4BookIds(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds, String strSceneIds) {
        if(CollUtil.isEmpty(adviserIds) || CollUtil.isEmpty(bookIds) || CollUtil.isEmpty(channelIds)){
            return new HashMap<>();
        }
        List<BookGroupServeCountDTO> list = bookQrcodeWxworkDao.mapWxWorkServeCount4BookIds(adviserIds, bookIds, channelIds, strSceneIds, BookQrcodeType.OFFICIAL_ACCOUNTS.getCode());
        if(CollUtil.isEmpty(list)){
            return new HashMap<>();
        }
        Map<String, BookGroupServeCountDTO> resultMap = list.stream().collect(Collectors.toMap(x -> x.getBookChannelAdviserId(), x -> x, (v1, v2) -> v2));
        return CollUtil.isEmpty(resultMap) ? new HashMap<>() : resultMap;
    }

    @Override
    public List<Long> getHasWxWorkCode(List<Long> sceneIds) {
        if(CollUtil.isEmpty(sceneIds)){
            return new ArrayList<>();
        }
        List<Long> result = bookQrcodeWxworkDao.getHasWxWorkCode(sceneIds);
        return result;
    }

    @Override
    public List<WxworkQrcodeDTO> getWxworkQrcodesBySceneId4Official(Long sceneId) {
        if (null == sceneId) {
            return new ArrayList<>();
        }
        List<BookQrcodeWxwork> wxworkList = bookQrcodeWxworkDao.getByQrcodeId(sceneId, BookQrcodeType.OFFICIAL_ACCOUNTS.getCode());
        if (ListUtils.isEmpty(wxworkList)) {
            return new ArrayList<>();
        }
        List<WxworkQrcodeDTO> wxworkQrcodeDTOS  = new ArrayList<>();
        for (BookQrcodeWxwork wxwork:wxworkList) {
            Integer wxworkQrcodeType = wxwork.getWxworkQrcodeType();
            Long wxworkQrcodeId = wxwork.getWxworkQrcodeId();
            WxworkQrcodeDTO dto = new WxworkQrcodeDTO();
            dto.setWxworkQrcodeId(wxworkQrcodeId);
            dto.setWxworkQrcodeType(wxworkQrcodeType);
            if (WxworkQrcodeType.SOP_QRCODE.getCode().equals(wxworkQrcodeType)) {
                WxworkQrcodeBaseDTO wxworkQrcodeBaseDTO = wechatGroupConsr.getWxworkQrcodeBaseById(wxworkQrcodeId);
                if (null != wxworkQrcodeBaseDTO) {
                    dto.setWxworkQrcodeUrl(wxworkQrcodeBaseDTO.getQrcodeUrl());
                    dto.setWxworkQrcodeName(wxworkQrcodeBaseDTO.getQrcodeName());
                    dto.setGuide(wxworkQrcodeBaseDTO.getGuideAccounts());
                }
            }else if (WxworkQrcodeType.GROUP_QRCODE.getCode().equals(wxworkQrcodeType)) {
                WxworkGroupQrcodeBaseDTO groupQrcodeBaseDTO = wechatGroupConsr.getWxworkGroupQrcodeBaseById(wxworkQrcodeId);
                if (null != groupQrcodeBaseDTO){
                    dto.setWxworkQrcodeUrl(groupQrcodeBaseDTO.getGroupQrcodeUrl());
                    dto.setWxworkQrcodeName(groupQrcodeBaseDTO.getGroupQrcodeName());
                    dto.setGuide(groupQrcodeBaseDTO.getInvitationAccounts());
                }
            }else if (WxworkQrcodeType.CRM_QRCODE.getCode().equals(wxworkQrcodeType)) {
                CrmContactQrcodeVO crmContactQrcodeVO = erpConsr.getContactQrcodeNameById4Adviser(wxworkQrcodeId);
                if (null != crmContactQrcodeVO) {
                    dto.setWxworkQrcodeUrl(crmContactQrcodeVO.getQrcodeUrl());
                    dto.setWxworkQrcodeName(crmContactQrcodeVO.getContactQrcodeName());
                    dto.setGuide(wxwork.getGuide());
                }
            }
            wxworkQrcodeDTOS.add(dto);
        }
        return wxworkQrcodeDTOS;
    }
}
