package com.pcloud.book.consumer.wxwork;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.wxwork.contact.service.WxContactService;
import com.pcloud.facade.wxwork.contact.vo.WxContactWayVO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.book.consumer.wxwork.WxworkConsr
 * @Author zhuyajie
 * @Description 企业微信
 * @Date 2021/12/2 18:42
 **/
@Slf4j
@Component
public class WxworkConsr {

    @Autowired
    private WxContactService wxContactService;

    @ParamLog("查个人活码")
    public WxContactWayVO getContactWayById(Long partyId, String systemCode, Long contactId) {
        try {
            return ResponseHandleUtil.parseResponse(wxContactService.getContactWayById(partyId, systemCode, contactId),WxContactWayVO.class);

        } catch (Exception e) {
            log.error("调用wxContactService.getContactWayById失败"+e.getMessage(),e);
        }
        return null;
    }
}
