package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageDao;
import com.pcloud.book.group.dto.AddBookGroupServeDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.book.group.vo.ResourcePageVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.utils.ListUtils;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageDaoImpl
 * @Author zhuyajie
 * @Description 自有码H5页面
 * @Date 2021/3/26 15:32
 * @Version 1.0
 **/
@Component
public class ResourcePageDaoImpl extends BaseDaoImpl<ResourcePage> implements ResourcePageDao {
    @Override
    public ResourcePage getByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getByBookGroupId"), bookGroupId);
    }

    @Override
    public ResourcePage getByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        return getSessionTemplate().selectOne(getStatement("getByBookId"), map);
    }

    @Override
    public void updatePageUpdateTime(Long resourcePageId) {
        getSessionTemplate().update(getStatement("updatePageUpdateTime"), resourcePageId);
    }

    @Override
    public ResourcePage getBySceneId(Long sceneId) {
        return getSessionTemplate().selectOne(getStatement("getBySceneId"), sceneId);
    }

    @Override
    public ResourcePage getPageByOfficialScene(Long officialSceneId) {
        return getSessionTemplate().selectOne(getStatement("getPageByOfficialScene"), officialSceneId);
    }

    @Override
    public List<Long> getOpenRaysSceneIds(List<Long> sceneIds) {
        return getSessionTemplate().selectList(getStatement("getOpenRaysSceneIds"), sceneIds);
    }

    @Override
    public void batchUpdateSceneIdByBookGroup(List<AddBookGroupServeDTO> list) {
        getSessionTemplate().update(getStatement("batchUpdateSceneIdByBookGroup"), list);
    }

    @Override
    public ResourcePage getPageByColumnId(Long resourcePageColumnId) {
        return getSessionTemplate().selectOne(getStatement("getPageByColumnId"), resourcePageColumnId);
    }

    @Override
    public List<Long> getSceneIdsByResourceId(Long resourceId) {
        return getSessionTemplate().selectList(getStatement("getSceneIdsByResourceId"), resourceId);
    }

    @Override
    public void updateBookBySceneIds(List<Long> sceneIds, Long bookId, Long channelId) {
        Map<String, Object> map = new HashMap<>();
        map.put("sceneIds", sceneIds);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        getSessionTemplate().update(getStatement("updateBookBySceneIds"), map);
    }

    @Override
    public void setOtherPageRaysClose(Long bookId, Long channelId, Long createUser, Long sceneId, Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("createUser", createUser);
        map.put("bookGroupId", bookGroupId);
        map.put("sceneId", sceneId);
        getSessionTemplate().update(getStatement("setOtherPageRaysClose"), map);
    }

    @Override
    public Boolean isOpenRaysBook(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        return getSessionTemplate().selectOne(getStatement("isOpenRaysBook"), map);
    }

    @Override
    public Map<String, BookGroupServeCountDTO> mapRaysCodeServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds) {
        if (bookIds != null && bookIds.size() > 500) {
            Map<String, BookGroupServeCountDTO>resultMap = new HashMap<>();
            List<List<Long>> lists = ListUtils.groupList(bookIds);
            for (List<Long> list : lists) {
                Map<String, Object> map = new HashMap<>();
                map.put("adviserIds", adviserIds);
                map.put("bookIds", list);
                map.put("channelIds", channelIds);
                Map<String, BookGroupServeCountDTO> objectObjectMap = getSessionTemplate().selectMap(getStatement("mapRaysCodeServeCount"), map, "bookChannelAdviserId");
                if(objectObjectMap!=null){
                    resultMap.putAll(objectObjectMap);
                }
            }
            return resultMap;
        } else {
            Map<String, Object> map = new HashMap<>();
            map.put("adviserIds", adviserIds);
            map.put("bookIds", bookIds);
            map.put("channelIds", channelIds);
            return getSessionTemplate().selectMap(getStatement("mapRaysCodeServeCount"), map, "bookChannelAdviserId");
        }
    }

    @Override
    public List<ResourcePageVO> getAllBook4OpenFood() {
        return getSessionTemplate().selectList(getStatement("getAllBook4OpenFood"));
    }

    @Override
    public void updateBookIdBySceneId(Long bookId, Long sceneId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("sceneId", sceneId);
        getSessionTemplate().update(getStatement("updateBookIdBySceneId"), map);
    }

    @Override
    public void updateNavigationFormat(Long resourcePageId, Integer navigationColor, Integer navigationFormat, Integer navigationJumpType) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", resourcePageId);
        map.put("navigationColor", navigationColor);
        map.put("navigationFormat", navigationFormat);
        map.put("navigationJumpType", navigationJumpType);
        getSessionTemplate().update(getStatement("updateNavigationFormat"), map);
    }
}
