package com.pcloud.book.group.vo;

import com.pcloud.book.group.entity.ResourcePageNavigation;
import com.pcloud.common.dto.BaseDto;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;

import lombok.Data;

/**
 * 自有码H5页面(ResourcePage)实体类
 *
 * @author makejava
 * @since 2021-03-26 15:25:28
 */
@Data
public class ResourcePageVO extends BaseDto {
    private static final long serialVersionUID = 220369810358566952L;
    private Long id;
    /**
    * rays码id
    */
    private Long bookGroupId;
    /**
    * 风格类型（1默认2艺术3插画）
    */
    private Integer style;
    /**
    * 是否显示图书信息
    */
    private Integer showBook;
    /**
    * 是否开启小睿流程
    */
    private Integer openRays;
    /**
     * 是否开启世间食记
     */
    private Integer openFood;
    /**
     * 书刊封面
     */
    private String bookImg;
    /**
     * 书刊名称
     */
    private String bookName;
    /**
     * 所属出版社
     */
    private String agentName;
    /**
     * 预览二维码
     */
    private String qrcodeUrl;
    /**
     * 上次阅读时间
     */
    private String lastReadTime;

    private String appletId;

    private Long sceneId;

    private Long bookId;
    private Long channelId;
    private Long adviserId;
    private Long accountSettingId;

    /**
     * 收藏状态
     */
    private Integer collectState;

    private String qrcodeLink;

    /**
     * 自定义配置的图书封面
     */
    private String bookCover;
    /**
     * 二维码名称
     */
    private String qrcodeName;
    /**
     * 扫码推送二维码名称权限状态
     */
    private Integer pushTextOpenStatus;

    /**
     * 背景图
     */
    private String backgroundImg;

    @ApiModelProperty("实体书购买")
    private List<ResourcePageBookstoreVO> resourcePageBookstoreList;

    @ApiModelProperty("优惠券")
    private List<ResourcePageBookstoreVO> resourcePageCouponList;
    /**
     * 导航
     */
    private List<ResourcePageNavigation> navigationList;
    /**
     * 导航颜色样式
     */
    private Integer navigationColor;
    /**
     * 导航版式
     */
    private Integer navigationFormat;
    /**
     * 字体颜色
     */
    private String fontColor;

    /**
     * 图书印章
     */
    private String watermark;
    /**
     * 图书印章样式
     */
    private Integer watermarkStyle;
    @ApiModelProperty("RAYS码落地页类型1本书服务2企微")
    private Integer landingPageType;
    @ApiModelProperty("企业微信落地页信息")
    private WxworkPageVO wxworkPageVO;
    /**
     * 透明度
     */
    private Integer transparency;
    /**
     * 导航使用场景；1：菜单切换；2：功能跳转
     */
    private Integer navigationJumpType;
}
