/**
 * 
 */
package com.pcloud.book.mq.topic;

import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.channelcenter.qrcode.dto.BookQrcodeUpdateDto;
import com.pcloud.common.exceptions.BizException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 二维码变更书刊
 * @author：zhuyajie
 * @date：2021/7/2 10:51
 *  * @param null
 */
@Component
@RabbitListener(queues = MQTopicConumer.QRCODE_BOOK_UPDATE)
public class QrcodeBookUpdateListener {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(QrcodeBookUpdateListener.class);

	@Autowired
	private ResourcePageBiz resourcePageBiz;

	/**
	 * 二维码变更书刊消息
	 */
	@RabbitHandler
	public void process(BookQrcodeUpdateDto bookQrcodeUpdateDto) throws BizException {
		if (null == bookQrcodeUpdateDto || null == bookQrcodeUpdateDto.getBookId()
				|| null == bookQrcodeUpdateDto.getSceneId()) {
			return;
		}
		try {
			Long bookId = bookQrcodeUpdateDto.getBookId();
			Long sceneId = bookQrcodeUpdateDto.getSceneId();
			//book_group表/resource_page更新bookid
			resourcePageBiz.updateBookId(bookId, sceneId);
		} catch (Exception e) {
			LOGGER.error("【二维码变更书刊】消费topic,JMS异常,<ERROR>:" + e.getMessage(), e);
		}
	}
}
