/**
 *
 */
package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @描述：书籍实体DTO
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:30:06 @版本：1.0
 */
public class BookDto extends BaseDto {

    /**
     *
     */
    private static final long serialVersionUID = -162839217433038629L;

    /**
     * 书籍标识
     */
    private Long bookId;

    /**
     * 类型编码
     */
    private String typeCode;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 书籍ISBN码
     */
    private String isbn;

    private Integer isDelete;

    /**
     * 书籍名称
     */
    private String bookName;

    /**
     * 书籍价格
     */
    private String bookPrice;

    /**
     * 图书原名
     */
    private String originName;

    /**
     * 简介
     */
    private String remark;

    /**
     * 作者
     */
    private String author;

    /**
     * 出版社
     */
    private String publish;

    /**
     * 出版时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date publishDate;

    /**
     * 封面图
     */
    private String coverImg;

    /**
     * 详情
     */
    private String detail;

    /**
     * 主办单位
     */
    private String sponsor;

    /**
     * 主管单位
     */
    private String organizer;

    /**
     * CN
     */
    private String cn;

    /**
     * 发行周期
     */
    private String releaseCycle;

    /**
     * 期物刊数
     */
    private String bookNum;

    /**
     * 栏目
     */
    private String programa;

    /**
     * 邮发代号
     */
    private String mailCode;

    /**
     * 地址
     */
    private String address;

    /**
     * 电话
     */
    private String telephone;

    /**
     * 邮箱
     */
    private String mail;

    /**
     * 宗旨
     */
    private String purpose;

    /**
     * 编辑标识
     */
    private Long adviserId;

    /**
     * 编辑名称
     */
    private String adviserName;

    /**
     * 渠道标识
     */
    private Long channelId;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 二维码数量
     */
    private Integer qrcodeCount;

    /**
     * 应用数量
     */
    private Integer appCount;

    /**
     * 作品数量
     */
    private Integer productCount;

    /**
     * 最新二维码
     */
    private String latestQrcode;

    /**
     * 应用列表
     */
    private List<Object> apps;

    /**
     * 作品列表
     */
    private List<Object> products;

    /**
     * 资源列表
     */
    private List<Object> resourceFiles;

    /**
     * 第一次扫描时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstScanDate;

    /**
     * 首次来源二维码名称
     */
    private String firstSceneName;

    /**
     * 期刊号
     */
    private String issn;

    /**
     * 关联应用标识
     */
    private Long appId;

    /**
     * 刊物序号
     */
    private String serialNumber;

    /**
     * 是否加入书架
     */
    private Boolean isSelect;

    /**
     * 宣传图
     */
    private String adImg;

    /**
     * 是否是主编辑
     */
    private Boolean isMainEditor;

    /**
     * 主编辑名称
     */
    private String mainEditorName;

    /**
     * 主编辑头像
     */
    private String mainEditorPic;

    /**
     * 书刊是否有编辑关联
     */
    private Boolean isHaveAdviser;

    /**
     * 书刊是否有基金支持
     */
    private Boolean isFundSupport;

    /**
     * 书刊是否有基金
     */
    private Boolean isHaveFund;

    /**
     * 书籍扫描数
     */
    private Long bookScanCount;

    /**
     * 书籍二维码数
     */
    private Long bookQrCount;

    /**
     * 书刊读者数
     */
    private Integer readerCount;

    /**
     * 书刊总收益
     */
    private BigDecimal bookIncome;

    /**
     * 基金收益
     */
    private BigDecimal fundMoney;

    /**
     * 基金列表
     */
    private List<BookFundDto> bookFunds;

    /**
     * 出版类型
     */
    private Integer agentType;

    /**
     * 基金支持开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 基金支持结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 二维码标识
     */
    private Long sceneId;
    /**
     * 父模板标识
     */
    private Long templeParentId;

    /**
     * 模板标识
     */
    private Long templetId;

    /**
     * 模板名称
     */
    private String templetName;

    /**
     * 浏览量
     */
    private Long browseCounts;

    /**
     * 读者量
     */
    private Long browserCounts;

    /**
     * 扫描量
     */
    private Long scanCount;

    /**
     * 冻结状态
     */
    private Integer FreezeStatus;

    /**
     * 图书总收益
     */
    private BigDecimal income;

    /**
     * 编辑图书关联标识
     */
    private Long bookAdviserId;

    /**
     * 图书是否关二维码联
     */
    private Boolean relationQrcode;

    /**
     * 待审核数量
     */
    private Long noAuditNum;

    private String transferor;

    // 二维码相关信息

    private String qrcodeUrl;
    /**
     * 配置服务个数
     */
    private Integer messageCount;

    /**
     * 类型名称
     */
    private List<String> typeCodeNames;
    /**
     * 印码位置
     */
    private String location;
    /**
     * 二维码名字
     */
    private String sceneName;
    /**
     * 二维码导读字段
     */
    private String qrRemark;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    /**
     * 是否开启广告位权限
     */
    private Boolean isOpen;

    /**
     * 出版ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;

    /**
     * 投放时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date distributionTime;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 广告位数量
     */
    private Long advertisingSpaceNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 公众号名称
     */
    private String officialAccountsName;

    /**
     * 唯一编号
     */
    private String uniqueNumber;

    /**
     * 社群码数据
     */
    /**
     * 是否是社群书
     */
    private Boolean isBookGroup;

    /**
     * 社群码ID
     */
    private Long bookGroupId;

    /**
     * 社群码图片
     */
    private String groupQrcodeUrl;

    /**
     * 社群码名称
     */
    private String groupQrcodeName;

    /**
     * 社群码深度标签
     */
    private Long depLabelId;

    /**
     * 群分类数量
     */
    private Long classifyCount;

    /**
     * 群总人数
     */
    private Long groupPersonCount;

    /**
     * 群数量
     */
    private Long groupCount;

    /**
     * 累计收益
     */
    private BigDecimal totalIncome;

    /**
     * 社群码链接
     */
    private String groupQrcodeLink;

    /**
     * 第二级类型
     */
    private Long secondTempletId;

    /**
     * 第二级类型typeCode
     */
    private String secondTypeCode;

    /**
     * 报名量
     */
    private Long registerNum;
    /**
     * 报名率
     */
    private BigDecimal registerRate;
    /**
     * 点击读者量
     */
    private Long clickUserNum;

    /**
     * 试听完成人数（完课量）
     */
    private Long pilotFinishUserNum;

    /**
     * 试听完成比率（完课率）
     */
    private BigDecimal pilotFinishRate;

    /**
     * 平均浏览时长
     */
    private BigDecimal avgBrowseTimes;
    /**
     * 跳出量
     */
    private Long outNum;
    /**
     * 跳出率
     */
    private BigDecimal outRate;

    public String getQrRemark() {
        return qrRemark;
    }

    public void setQrRemark(String qrRemark) {
        this.qrRemark = qrRemark;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public Integer getMessageCount() {
        return messageCount;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    public Long getNoAuditNum() {
        return noAuditNum;
    }

    public void setNoAuditNum(Long noAuditNum) {
        this.noAuditNum = noAuditNum;
    }

    public Integer getFreezeStatus() {
        return FreezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        FreezeStatus = freezeStatus;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getFirstSceneName() {
        return firstSceneName;
    }

    public void setFirstSceneName(String firstSceneName) {
        this.firstSceneName = firstSceneName;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getFirstScanDate() {
        return firstScanDate;
    }

    public void setFirstScanDate(Date firstScanDate) {
        this.firstScanDate = firstScanDate;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public List<Object> getProducts() {
        return products;
    }

    public void setProducts(List<Object> products) {
        this.products = products;
    }

    public Integer getQrcodeCount() {
        return qrcodeCount;
    }

    public void setQrcodeCount(Integer qrcodeCount) {
        this.qrcodeCount = qrcodeCount;
    }

    public Integer getAppCount() {
        return appCount;
    }

    public void setAppCount(Integer appCount) {
        this.appCount = appCount;
    }

    public Integer getProductCount() {
        return productCount;
    }

    public void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Boolean getSelect() {
        return isSelect;
    }

    public void setSelect(Boolean select) {
        isSelect = select;
    }

    public Boolean getMainEditor() {
        return isMainEditor;
    }

    public void setMainEditor(Boolean mainEditor) {
        isMainEditor = mainEditor;
    }

    public Boolean getHaveAdviser() {
        return isHaveAdviser;
    }

    public void setHaveAdviser(Boolean haveAdviser) {
        isHaveAdviser = haveAdviser;
    }

    public Boolean getFundSupport() {
        return isFundSupport;
    }

    public void setFundSupport(Boolean fundSupport) {
        isFundSupport = fundSupport;
    }

    public Boolean getHaveFund() {
        return isHaveFund;
    }

    public void setHaveFund(Boolean haveFund) {
        isHaveFund = haveFund;
    }

    public Boolean getOpen() {
        return isOpen;
    }

    public void setOpen(Boolean open) {
        isOpen = open;
    }

    public Boolean getBookGroup() {
        return isBookGroup;
    }

    public void setBookGroup(Boolean bookGroup) {
        isBookGroup = bookGroup;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPublish() {
        return publish;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getSponsor() {
        return sponsor;
    }

    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    public String getOrganizer() {
        return organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public String getCn() {
        return cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getReleaseCycle() {
        return releaseCycle;
    }

    public void setReleaseCycle(String releaseCycle) {
        this.releaseCycle = releaseCycle;
    }

    public String getBookNum() {
        return bookNum;
    }

    public void setBookNum(String bookNum) {
        this.bookNum = bookNum;
    }

    public String getPrograma() {
        return programa;
    }

    public void setPrograma(String programa) {
        this.programa = programa;
    }

    public String getMailCode() {
        return mailCode;
    }

    public void setMailCode(String mailCode) {
        this.mailCode = mailCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getOriginName() {
        return originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getBookPrice() {
        return bookPrice;
    }

    public void setBookPrice(String bookPrice) {
        this.bookPrice = bookPrice;
    }

    public String getIssn() {
        return issn;
    }

    public void setIssn(String issn) {
        this.issn = issn;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Boolean getIsSelect() {
        return isSelect;
    }

    public void setIsSelect(Boolean isSelect) {
        this.isSelect = isSelect;
    }

    public String getAdImg() {
        return adImg;
    }

    public void setAdImg(String adImg) {
        this.adImg = adImg;
    }

    public String getLatestQrcode() {
        return latestQrcode;
    }

    public void setLatestQrcode(String latestQrcode) {
        this.latestQrcode = latestQrcode;
    }

    public Boolean getIsMainEditor() {
        return isMainEditor;
    }

    public void setIsMainEditor(Boolean isMainEditor) {
        this.isMainEditor = isMainEditor;
    }

    public String getMainEditorName() {
        return mainEditorName;
    }

    public void setMainEditorName(String mainEditorName) {
        this.mainEditorName = mainEditorName;
    }

    public String getMainEditorPic() {
        return mainEditorPic;
    }

    public void setMainEditorPic(String mainEditorPic) {
        this.mainEditorPic = mainEditorPic;
    }

    public Boolean getIsHaveAdviser() {
        return isHaveAdviser;
    }

    public void setIsHaveAdviser(Boolean isHaveAdviser) {
        this.isHaveAdviser = isHaveAdviser;
    }

    public Long getBookScanCount() {
        return bookScanCount;
    }

    public void setBookScanCount(Long bookScanCount) {
        this.bookScanCount = bookScanCount;
    }

    public Long getBookQrCount() {
        return bookQrCount;
    }

    public void setBookQrCount(Long bookQrCount) {
        this.bookQrCount = bookQrCount;
    }

    public Boolean getIsFundSupport() {
        return isFundSupport;
    }

    public void setIsFundSupport(Boolean isFundSupport) {
        this.isFundSupport = isFundSupport;
    }

    public Integer getReaderCount() {
        return readerCount;
    }

    public void setReaderCount(Integer readerCount) {
        this.readerCount = readerCount;
    }

    public BigDecimal getBookIncome() {
        return bookIncome;
    }

    public void setBookIncome(BigDecimal bookIncome) {
        this.bookIncome = bookIncome;
    }

    public BigDecimal getFundMoney() {
        return fundMoney;
    }

    public void setFundMoney(BigDecimal fundMoney) {
        this.fundMoney = fundMoney;
    }

    public Boolean getIsHaveFund() {
        return isHaveFund;
    }

    public void setIsHaveFund(Boolean isHaveFund) {
        this.isHaveFund = isHaveFund;
    }

    public List<BookFundDto> getBookFunds() {
        return bookFunds;
    }

    public void setBookFunds(List<BookFundDto> bookFunds) {
        this.bookFunds = bookFunds;
    }

    public Integer getAgentType() {
        return agentType;
    }

    public void setAgentType(Integer agentType) {
        this.agentType = agentType;
    }

    public List<Object> getApps() {
        return apps;
    }

    public void setApps(List<Object> apps) {
        this.apps = apps;
    }

    public List<Object> getResourceFiles() {
        return resourceFiles;
    }

    public void setResourceFiles(List<Object> resourceFiles) {
        this.resourceFiles = resourceFiles;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getTempletId() {
        return templetId;
    }

    public void setTempletId(Long templetId) {
        this.templetId = templetId;
    }

    public String getTempletName() {
        return templetName;
    }

    public void setTempletName(String templetName) {
        this.templetName = templetName;
    }

    public Long getBrowseCounts() {
        return browseCounts;
    }

    public void setBrowseCounts(Long browseCounts) {
        this.browseCounts = browseCounts;
    }

    public Long getBrowserCounts() {
        return browserCounts;
    }

    public void setBrowserCounts(Long browserCounts) {
        this.browserCounts = browserCounts;
    }

    public Long getScanCount() {
        return scanCount;
    }

    public void setScanCount(Long scanCount) {
        this.scanCount = scanCount;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public Long getBookAdviserId() {
        return bookAdviserId;
    }

    public void setBookAdviserId(Long bookAdviserId) {
        this.bookAdviserId = bookAdviserId;
    }

    public Boolean getRelationQrcode() {
        return relationQrcode;
    }

    public void setRelationQrcode(Boolean relationQrcode) {
        this.relationQrcode = relationQrcode;
    }

    public Long getTempleParentId() {
        return templeParentId;
    }

    public void setTempleParentId(Long templeParentId) {
        this.templeParentId = templeParentId;
    }

    public List<String> getTypeCodeNames() {
        return typeCodeNames;
    }

    public void setTypeCodeNames(List<String> typeCodeNames) {
        this.typeCodeNames = typeCodeNames;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public String getOfficialAccountsName() {
        return officialAccountsName;
    }

    public void setOfficialAccountsName(String officialAccountsName) {
        this.officialAccountsName = officialAccountsName;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public String getUniqueNumber() {
        return uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }

    public Long getClassifyCount() {
        return classifyCount;
    }

    public void setClassifyCount(Long classifyCount) {
        this.classifyCount = classifyCount;
    }

    public Long getGroupPersonCount() {
        return groupPersonCount;
    }

    public void setGroupPersonCount(Long groupPersonCount) {
        this.groupPersonCount = groupPersonCount;
    }

    public Long getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Long groupCount) {
        this.groupCount = groupCount;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getGroupQrcodeLink() {
        return groupQrcodeLink;
    }

    public void setGroupQrcodeLink(String groupQrcodeLink) {
        this.groupQrcodeLink = groupQrcodeLink;
    }

    public Long getSecondTempletId() {
        return secondTempletId;
    }

    public void setSecondTempletId(Long secondTempletId) {
        this.secondTempletId = secondTempletId;
    }

    public String getSecondTypeCode() {
        return secondTypeCode;
    }

    public void setSecondTypeCode(String secondTypeCode) {
        this.secondTypeCode = secondTypeCode;
    }

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public Long getAdvertisingSpaceNum() {
        return advertisingSpaceNum;
    }

    public void setAdvertisingSpaceNum(Long advertisingSpaceNum) {
        this.advertisingSpaceNum = advertisingSpaceNum;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    public BigDecimal getRegisterRate() {
        return registerRate;
    }

    public void setRegisterRate(BigDecimal registerRate) {
        this.registerRate = registerRate;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    public Long getPilotFinishUserNum() {
        return pilotFinishUserNum;
    }

    public void setPilotFinishUserNum(Long pilotFinishUserNum) {
        this.pilotFinishUserNum = pilotFinishUserNum;
    }

    public BigDecimal getPilotFinishRate() {
        return pilotFinishRate;
    }

    public void setPilotFinishRate(BigDecimal pilotFinishRate) {
        this.pilotFinishRate = pilotFinishRate;
    }

    public BigDecimal getAvgBrowseTimes() {
        return avgBrowseTimes;
    }

    public void setAvgBrowseTimes(BigDecimal avgBrowseTimes) {
        this.avgBrowseTimes = avgBrowseTimes;
    }

    public Long getOutNum() {
        return outNum;
    }

    public void setOutNum(Long outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutRate() {
        return outRate;
    }

    public void setOutRate(BigDecimal outRate) {
        this.outRate = outRate;
    }

    @Override
    public String toString() {
        return "BookDto{" +
                "bookId=" + bookId +
                ", typeCode='" + typeCode + '\'' +
                ", typeName='" + typeName + '\'' +
                ", isbn='" + isbn + '\'' +
                ", bookName='" + bookName + '\'' +
                ", bookPrice='" + bookPrice + '\'' +
                ", originName='" + originName + '\'' +
                ", remark='" + remark + '\'' +
                ", author='" + author + '\'' +
                ", publish='" + publish + '\'' +
                ", publishDate=" + publishDate +
                ", coverImg='" + coverImg + '\'' +
                ", detail='" + detail + '\'' +
                ", sponsor='" + sponsor + '\'' +
                ", organizer='" + organizer + '\'' +
                ", cn='" + cn + '\'' +
                ", releaseCycle='" + releaseCycle + '\'' +
                ", bookNum='" + bookNum + '\'' +
                ", programa='" + programa + '\'' +
                ", mailCode='" + mailCode + '\'' +
                ", address='" + address + '\'' +
                ", telephone='" + telephone + '\'' +
                ", mail='" + mail + '\'' +
                ", purpose='" + purpose + '\'' +
                ", adviserId=" + adviserId +
                ", adviserName='" + adviserName + '\'' +
                ", channelId=" + channelId +
                ", channelName='" + channelName + '\'' +
                ", qrcodeCount=" + qrcodeCount +
                ", appCount=" + appCount +
                ", productCount=" + productCount +
                ", latestQrcode='" + latestQrcode + '\'' +
                ", apps=" + apps +
                ", products=" + products +
                ", resourceFiles=" + resourceFiles +
                ", firstScanDate=" + firstScanDate +
                ", firstSceneName='" + firstSceneName + '\'' +
                ", issn='" + issn + '\'' +
                ", appId=" + appId +
                ", serialNumber='" + serialNumber + '\'' +
                ", isSelect=" + isSelect +
                ", adImg='" + adImg + '\'' +
                ", isMainEditor=" + isMainEditor +
                ", mainEditorName='" + mainEditorName + '\'' +
                ", mainEditorPic='" + mainEditorPic + '\'' +
                ", isHaveAdviser=" + isHaveAdviser +
                ", isFundSupport=" + isFundSupport +
                ", isHaveFund=" + isHaveFund +
                ", bookScanCount=" + bookScanCount +
                ", bookQrCount=" + bookQrCount +
                ", readerCount=" + readerCount +
                ", bookIncome=" + bookIncome +
                ", fundMoney=" + fundMoney +
                ", bookFunds=" + bookFunds +
                ", agentType=" + agentType +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", sceneId=" + sceneId +
                ", templeParentId=" + templeParentId +
                ", templetId=" + templetId +
                ", templetName='" + templetName + '\'' +
                ", browseCounts=" + browseCounts +
                ", browserCounts=" + browserCounts +
                ", scanCount=" + scanCount +
                ", FreezeStatus=" + FreezeStatus +
                ", income=" + income +
                ", bookAdviserId=" + bookAdviserId +
                ", relationQrcode=" + relationQrcode +
                ", noAuditNum=" + noAuditNum +
                ", transferor='" + transferor + '\'' +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", messageCount=" + messageCount +
                ", typeCodeNames=" + typeCodeNames +
                ", location='" + location + '\'' +
                ", sceneName='" + sceneName + '\'' +
                ", qrRemark='" + qrRemark + '\'' +
                ", bookStatus=" + bookStatus +
                ", isOpen=" + isOpen +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", distributionTime=" + distributionTime +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", advertisingSpaceNum=" + advertisingSpaceNum +
                ", clickRate=" + clickRate +
                ", officialAccountsName='" + officialAccountsName + '\'' +
                ", uniqueNumber='" + uniqueNumber + '\'' +
                ", isBookGroup=" + isBookGroup +
                ", bookGroupId=" + bookGroupId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", depLabelId=" + depLabelId +
                ", classifyCount=" + classifyCount +
                ", groupPersonCount=" + groupPersonCount +
                ", groupCount=" + groupCount +
                ", totalIncome=" + totalIncome +
                ", groupQrcodeLink='" + groupQrcodeLink + '\'' +
                ", secondTempletId=" + secondTempletId +
                ", secondTypeCode='" + secondTypeCode + '\'' +
                ", registerNum=" + registerNum +
                ", registerRate=" + registerRate +
                ", clickUserNum=" + clickUserNum +
                ", pilotFinishUserNum=" + pilotFinishUserNum +
                ", pilotFinishRate=" + pilotFinishRate +
                ", avgBrowseTimes=" + avgBrowseTimes +
                ", outNum=" + outNum +
                ", outRate=" + outRate +
                '}';
    }
}
