package com.pcloud.book.clock.service;

import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "bookClockInfoServiceCloud", path = "book/v1.0/bookClockInfoService")
@Api(description = "微信群打卡内部服务")
public interface BookClockInfoService {

    @ApiOperation("获取微信群某一动作动作关键词")
    @RequestMapping(value = "getBookClockKeyword4Clock",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupClockKeywordDTO>> getBookClockKeyword4Clock(@RequestParam("bookClockInfoId") Long bookClockInfoId,
                                                                                    @RequestParam("operation") String operation) throws BizException;

    @ApiOperation("发送微信群打卡消息")
    @PostMapping("/sendBookClockGroupMessage")
    void sendBookClockGroupMessage(@RequestBody Map<String, Object> map) throws BizException;


}
