package com.pcloud.book.adnews.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhengyongqiang
 * @date 2019/8/7 11:23
 */
@ApiModel("新闻微信公众号")
public class AdNewsWechat extends BaseEntity {

    private static final long serialVersionUID = 454065623001378319L;

    public AdNewsWechat() {
    }

    public AdNewsWechat(String newsFrom, String wechatName, Long adviserId, Boolean isDelete) {
        this.newsFrom = newsFrom;
        this.wechatName = wechatName;
        this.adviserId = adviserId;
        this.isDelete = isDelete;
    }

    @ApiModelProperty("微信公众号唯一标识")
    private String newsFrom;

    @ApiModelProperty("微信公众号名称")
    private String wechatName;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getNewsFrom() {
        return newsFrom;
    }

    public void setNewsFrom(String newsFrom) {
        this.newsFrom = newsFrom;
    }

    public String getWechatName() {
        return wechatName;
    }

    public void setWechatName(String wechatName) {
        this.wechatName = wechatName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Boolean getDelete() {
        return isDelete;
    }

    public void setDelete(Boolean delete) {
        isDelete = delete;
    }

    @Override
    public String toString() {
        return "AdNewsWechat{" +
                "newsFrom='" + newsFrom + '\'' +
                ", wechatName='" + wechatName + '\'' +
                ", adviserId=" + adviserId +
                ", isDelete=" + isDelete +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }
}
