package com.pcloud.book.consumer.common;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.commoncenter.export.dto.ExportDto;
import com.pcloud.commoncenter.export.service.ExportService;

/**
 * @描述：Excel导出
 * @作者：user
 * @创建时间：2017年11月24日,18:39
 * @版本：1.0
 */
@Component("exportConsr")
public class ExportConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportConsr.class);

    @Autowired
    private ExportService exportService;

    /**
     * Excel导出
     * @param title Excel内容标题
     * @param rowsName 表头
     * @param dataList 数据内容
     */
    public String exportExcel(String title, String[] rowsName, List<Object[]> dataList) {
        LOGGER.info("Excel导出，参数列表title = "+title+" rowsName = "+rowsName);
        ExportDto exportDto = new ExportDto();
        exportDto.setDataList(dataList);
        exportDto.setRowsName(rowsName);
        exportDto.setTitle(title);
        String fileUrl="";
        try {
            ResponseEntity<ResponseDto<String>> response = exportService.exportExcel(exportDto);
            fileUrl = ResponseHandleUtil.parseResponse(response,String.class);
            LOGGER.info("Excel导出,return:" + fileUrl);
            return fileUrl;
        } catch (Exception e) {
            LOGGER.error("Excel导出失败[exportService.exportExcel]>>>>>" + e.getMessage(), e);
        }
		return fileUrl;
    }

}
