package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dao.BookAuthUserDao;
import com.pcloud.book.copyright.entity.BookAuthUser;
import com.pcloud.book.copyright.vo.BookAuthCodeUserVO;
import com.pcloud.book.copyright.vo.ProvinceTop10VO;
import com.pcloud.book.copyright.vo.SixMonthCountVO;
import com.pcloud.book.copyright.vo.ThirtyDayCountVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 15:56
 */
@Component("bookAuthUserDao")
public class BookAuthUserDaoImpl extends BaseDaoImpl<BookAuthUser> implements BookAuthUserDao {

    /**
     * 根据类型获取授权用户总数
     */
    @Override
    public BookAuthCodeUserVO getAuthUserCount(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId",adviserId);
        return this.getSqlSession().selectOne(this.getStatement("getAuthUserCount"), paramMap);
    }

    @Override
    public List<ThirtyDayCountVO> listThirtyDay(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("listThirtyDay"), paramMap);
    }

    @Override
    public List<SixMonthCountVO> listSixMonth(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("listSixMonth"), paramMap);
    }

    @Override
    public Boolean getIsHaveAuth(Long bookId, Long channelId, Long adviserId, Long wechatUserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("wechatUserId",wechatUserId);
        return this.getSqlSession().selectOne(this.getStatement("getIsHaveAuth"), paramMap);
    }

    @Override
    public BookAuthCodeUserVO getAuthUserCountByMonth(Long bookId, Long channelId, Long adviserId, String monthDate) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId",adviserId);
        if(!StringUtil.isEmpty(monthDate)){
            paramMap.put("monthDate",monthDate);
        }
        return this.getSqlSession().selectOne(this.getStatement("getAuthUserCountByMonth"), paramMap);
    }

    @Override
    public BookAuthCodeUserVO getAuthUserTotalCount(List<Long> adviserIds, List<Long> removeAdviserIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("adviserIds", adviserIds);
        paramMap.put("removeAdviserIds", removeAdviserIds);
        return this.getSqlSession().selectOne(this.getStatement("getAuthUserTotalCount"), paramMap);
    }

    @Override
    public List<ProvinceTop10VO> listTop10ByBook(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("listTop10ByBook"), paramMap);
    }

}
