package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lily
 * @date 2018/12/4 11:50
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookAuthInfoVO implements Serializable {

    @ApiModelProperty("图书授权信息标识")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("编码可使用次数")
    private Integer codeUseCount;

    @ApiModelProperty("购买链接地址")
    private String buyUrl;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("验证类型")
    private Integer checkType;

    @ApiModelProperty("位置描述")
    private String locationDesc;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getCodeUseCount() {
        return codeUseCount;
    }

    public void setCodeUseCount(Integer codeUseCount) {
        this.codeUseCount = codeUseCount;
    }

    public String getBuyUrl() {
        return buyUrl;
    }

    public void setBuyUrl(String buyUrl) {
        this.buyUrl = buyUrl;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public String getLocationDesc() {
        return locationDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    @Override
    public String toString() {
        return "BookAuthInfoVO{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", price=" + price +
                ", codeUseCount=" + codeUseCount +
                ", buyUrl='" + buyUrl + '\'' +
                ", bookStatus=" + bookStatus +
                ", checkType=" + checkType +
                ", locationDesc='" + locationDesc + '\'' +
                '}';
    }
}
