package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.AppClickDTO;
import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AppClickRecordDao extends BaseDao<AppClickRecord> {
    /**
     * 根据作品或应用id集合获取统计
     */
    List<AppStatisticsDTO> getClickStatisticsByServeIds(List<Long> serveIds, Long qrcodeId, Long bookGroupId);

    /**
     * 获取最近点击
     */
    List<AppClickDTO> getRecentlyClick(Long wechatUserId, Long qrcodeId, Integer top);
}
