package com.pcloud.book.group.service.impl;

import java.util.List;
import java.util.Map;


import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import com.pcloud.book.group.dto.GroupCipherDTO;
import com.pcloud.book.group.dto.GroupUseDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.service.BookGroupService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.dto.StoreFlowInfoDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * Description 社群书内部接口实现类
 * Created by PENG on 2019/5/14.
 */
@RestController("bookGroupService")
@RequestMapping("bookGroupService")
public class BookGroupServiceImpl implements BookGroupService {

    @Autowired
    private BookGroupBiz bookGroupBiz;

    /**
     * 获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupDTO>> getBookGroupInfo(@RequestParam("bookGroupId") Long bookGroupId) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfo(bookGroupId));
    }

    /**
     * 批量获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfoByIds", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long, BookGroupDTO>>> getBookGroupInfoByIds(@RequestBody List<Long> bookGroupIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfoByIds(bookGroupIds));
    }

    /**
     * 为信息流批量获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getFlowInfoByBookGroupIds", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getFlowInfoByBookGroupIds(@RequestBody List<Long> bookGroupIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getFlowInfoByBookGroupIds(bookGroupIds));
    }

    /**
     * 获取指定条数社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfoByChannelId",method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getBookGroupInfoByChannelId(@RequestParam("channelId")Long channelId, @RequestParam("itemNum")Integer itemNum) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfoByChannelId(channelId, itemNum));
    }

    /**
     * 知识商城获取社群书信息
     */
    @Override
    @RequestMapping(value = "listBookGroup4KnowledgeMall",method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<PageBeanNew<StoreFlowInfoDto>>> listBookGroup4KnowledgeMall(@RequestParam(value="channelId",required = false)Long channelId,
                                                                                                  @RequestParam("currentPage")int currentPage,
                                                                                                  @RequestParam("numPerPage") int numPerPage) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.listBookGroup4KnowledgeMall(channelId, currentPage, numPerPage));
    }

    /**
     * 获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBaseInfoBySceneId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupDTO>> getBaseInfoBySceneId(@RequestParam("sceneId") Long sceneId) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBaseInfoBySceneId(sceneId));
    }


    @Override
    @RequestMapping(value = "updatePersonQrcode",method = RequestMethod.POST)
    public void updatePersonQrcode(@RequestBody PersonalQrcodeDTO personalQrcodeDTO) throws BizException {
        bookGroupBiz.updatePersonQrcode(personalQrcodeDTO);
    }

    /**
     * 获取暗号状态
     */
    @ApiOperation("获取暗号状态")
    @GetMapping("/getCipherState")
    @Override
    public ResponseEntity<ResponseDto<Integer>> getCipherState(String cipher) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getCipherState(cipher));
    }

    /**
     * 更新密码状态为已使用
     */
    @ApiOperation("更新暗号状态为已使用")
    @GetMapping("/updateCipherStateToUsed")
    @Override
    public void updateCipherStateToUsed(String cipher, String wxId) throws BizException {
        bookGroupBiz.updateCipherStateToUsed(cipher,wxId);
    }

    /**
     * 获取个人二维码方式群已使用和未使用数量
     */
    @ApiOperation("获取个人二维码方式群已使用和未使用数量")
    @PostMapping("/getGroupUse")
    @Override
    public ResponseEntity<ResponseDto<GroupUseDTO>> getGroupUse(@RequestBody List<String> altIds) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getGroupUse(altIds));
    }

    @ApiOperation("获取暗号基本信息")
    @GetMapping("/getJoinGroupCipher")
    @Override
    public ResponseEntity<ResponseDto<GroupCipherDTO>> getJoinGroupCipher(@RequestParam("cipher")String cipher) throws BizException {
        return ResponseHandleUtil.toResponse(bookGroupBiz.getJoinGroupCipher(cipher));
    }

}
