package com.pcloud.book.riddle.dao.impl;

import com.pcloud.book.riddle.dao.RiddleRecordDao;
import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.entity.RiddleRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @描述：猜谜记录
 * @作者：zhuyajie
 * @创建时间：18:19 2019/7/24
 * @版本：1.0
 */
@Component("riddleRecordDao")
public class RiddleRecordDaoImpl extends BaseDaoImpl<RiddleRecord> implements RiddleRecordDao {


    @Override
    public RiddleRecord getLastRecordByWxGroupId(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getLastRecordByWxGroupId"), wxGroupId);
    }

    @Override
    public Integer getCorrectCountByGroup(String wxGroupId, Integer finishCount) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("finishCount", finishCount);
        return getSessionTemplate().selectOne(getStatement("getCorrectCountByGroup"), map);
    }

    @Override
    public GroupRiddleDTO getParticipateCount(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getParticipateCount"), wxGroupId);
    }
}
