package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/27 14:55
 **/
@ApiModel("广告位定时投放模型")
public class AdvertisingPut extends BaseEntity {

    private static final long serialVersionUID = 6433715659057254836L;

    @ApiModelProperty("广告位id")
    private Long advertisingSpaceId;

    @ApiModelProperty("广告位计划id")
    private Long advertisingPlanId;

    @ApiModelProperty("投放时间类型（1:单次发送 2:每天发送 3:每周发送）")
    private Integer putType;

    @ApiModelProperty("投放时间")
    private String putTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("周几")
    private Integer weekDay;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @ApiModelProperty("广告位")
    private AdvertisingSpace advertisingSpace;

    public Long getAdvertisingSpaceId() {
        return advertisingSpaceId;
    }

    public void setAdvertisingSpaceId(Long advertisingSpaceId) {
        this.advertisingSpaceId = advertisingSpaceId;
    }

    public Long getAdvertisingPlanId() {
        return advertisingPlanId;
    }

    public void setAdvertisingPlanId(Long advertisingPlanId) {
        this.advertisingPlanId = advertisingPlanId;
    }

    public Integer getPutType() {
        return putType;
    }

    public void setPutType(Integer putType) {
        this.putType = putType;
    }

    public String getPutTime() {
        return putTime;
    }

    public void setPutTime(String putTime) {
        this.putTime = putTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getWeekDay() {
        return weekDay;
    }

    public void setWeekDay(Integer weekDay) {
        this.weekDay = weekDay;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public AdvertisingSpace getAdvertisingSpace() {
        return advertisingSpace;
    }

    public void setAdvertisingSpace(AdvertisingSpace advertisingSpace) {
        this.advertisingSpace = advertisingSpace;
    }

    @Override
    public String toString() {
        return "AdvertisingPut{" +
                "advertisingSpaceId=" + advertisingSpaceId +
                ", advertisingPlanId=" + advertisingPlanId +
                ", putType=" + putType +
                ", putTime='" + putTime + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", weekDay=" + weekDay +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", advertisingSpace=" + advertisingSpace +
                "} " + super.toString();
    }
}
