package com.pcloud.book.clock.set;

import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.book.clock.entity.BookClockKeyword;
import com.pcloud.book.clock.entity.BookGroupClock;

import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/5/27 10:39
 * @Version 1.0
 */
public interface BookGroupClockSet {

    /**
     * 封装对象
     * @param bookClockInfo
     * @param isBookGroupId
     * @param ids
     * @return
     */
    List<BookGroupClock> setData4BookGroupClock(BookClockInfo bookClockInfo, Boolean isBookGroupId, List<Long> ids);

    /**
     * 封装关键词对象
     * @param bookClockInfoId
     * @param sequence
     * @param bookClockKeywordList
     */
    void setData4BookClockKeyword(Long bookClockInfoId,Long adviserId,Long sequence,List<BookClockKeyword> bookClockKeywordList);

    /**
     * 根据作品/应用获取关联的社群书及分类集合
     * @param bookClockInfoIds
     * @return
     */
    BookClockInfoDTO getGroupAndClassifyListByInfoIds(List<Long> bookClockInfoIds);

    /**
     * 创建定时任务
     * @param bookClockInfo
     */
    void createCronQuartz(BookClockInfo bookClockInfo);

    /**
     * 获取书集合与分类集合的重复部分
     * @param bookGroupIds
     * @param classifyIds
     * @param returnBookId
     * @return
     */
    List<Long> getSameClassifyUnderBookGroup(List<Long> bookGroupIds,List<Long> classifyIds,boolean returnBookId);

}
