package com.pcloud.book.pcloudkeyword.biz;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dto.PcloudTdDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudClassifyTemplate;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;

import java.util.List;
import java.util.Map;

public interface PcloudRobotBiz {

    void createPcloudRobot(PcloudRobot pcloudRobot);

    void updatePcloudRobot(PcloudRobot pcloudRobot);

    void updatePcloudRobotByWxId(PcloudRobot pcloudRobot);

    PageBeanNew<PcloudRobot> getPcloudRobotList(String nickName, Integer currentPage, Integer numPerPage);

    void batchUpdatePcloudRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList);

    PcloudRobot getPcloudRobot(Long id);

    void sendWelcomeReply(String robotWxId, String userWxId, String ip);

    void relateKeywordClassify(Long pcloudRobotId, Long keywordClassifyId);

    PcloudRobot getPcloudRobotByType(Integer robotType);

    PageBeanNew<PcloudClassifyTemplate> listClassifyTemplate(Integer classifyId, Integer currentPage, Integer numPerPage);

    void openTemplate(Integer classifyId, Long templateId);

    void uploadTemplateAudio(PcloudClassifyTemplate classifyTemplate);

    PcloudClassifyTemplate getTemplateByClassifyId(Integer classifyId);

    Map<String, RobotClassifyDTO> mapByIds4Classify(List<String> robotIds);

    List<RobotClassifyDTO> getAllPcloudRobot();

    PcloudRobot getPcloudRobotByWxId(String robotId);

    void editPcloudTd(PcloudTdDTO pcloudTdDTO);

    PcloudTdDTO getPcloudTdInfo();

    void handlePcloudTdReply(SendTextDTO sendTextDTO);

    void updateUserTdState(String robotWxId, String userWxId, Integer tdState);

    Integer getUserTdState(String robotWxId, String userWxId);

    String getTdKeyword();

    void copyRobotWelcome(String sourceRobotWxId, String targetRobotWxId);

    void copyRobotConfiguration(String sourceRobotWxId, String targetRobotWxId);
}
