package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.common.dto.ResponseDto;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import javax.annotation.Resource;

@RestController
@RequestMapping("pcloudRobotClassify")
public class PcloudRobotClassifyFacade {

    @Resource
    private PcloudRobotClassifyBiz pcloudRobotClassifyBiz;

    @GetMapping("listClassify")
    public ResponseDto<List<PcloudRobotClassifyResponseVO>> listClassify() {
        List<PcloudRobotClassifyResponseVO> classify = pcloudRobotClassifyBiz.listAllRobotClassify();
        return new ResponseDto<>(classify);
    }

    @PostMapping("saveRobotClassify")
    public ResponseDto<Void> saveRobotClassify(@RequestParam("classifyName") String classifyName) {
        pcloudRobotClassifyBiz.saveRobotClassify(classifyName);
        return new ResponseDto<>();
    }

    @PostMapping("updateRobotClassify")
    public ResponseDto<Void> updateRobotClassify(@RequestBody PcloudRobotClassify classify) {
        pcloudRobotClassifyBiz.updateRobotClassify(classify);
        return new ResponseDto<>();
    }

}
