package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lihao
 * @date 2018/8/26 14:27
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListHaveAuthGroupBookParam implements Serializable {

    @ApiModelProperty("isbn/issn/图书名称")
    private String name;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("图书类型标识")
    private Long templetId;

    @ApiModelProperty("第二级图书类型标识")
    private Long secondTempletId;

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer numPerPage;

    @ApiModelProperty("类型")
    private String typeCode;

    @ApiModelProperty("社群书状态")
    private Integer bookStatus;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getTempletId() {
        return templetId;
    }

    public void setTempletId(Long templetId) {
        this.templetId = templetId;
    }

    public Long getSecondTempletId() {
        return secondTempletId;
    }

    public void setSecondTempletId(Long secondTempletId) {
        this.secondTempletId = secondTempletId;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    @Override
    public String toString() {
        return "ListHaveAuthGroupBookParam{" +
                "name='" + name + '\'' +
                ", channelId=" + channelId +
                ", templetId=" + templetId +
                ", secondTempletId=" + secondTempletId +
                ", currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                ", typeCode='" + typeCode + '\'' +
                ", bookStatus=" + bookStatus +
                '}';
    }
}
