package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/17 14:17
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListClassifyVO implements Serializable {

    private Long id;

    @ApiModelProperty("分类")
    private String classify;

//    @ApiModelProperty("二维码地址")
//    private String qrcodeUrl;

    @ApiModelProperty("分类介绍")
    private String classifyIntroduce;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("换群数量")
    private Integer changeNumber;

    @ApiModelProperty("群数量")
    private Integer qrcodeNumber;

    @ApiModelProperty("群总用户数")
    private Integer userNumberTotal;

    @ApiModelProperty("排序")
    private Integer rank;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createdTime;

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getUserNumberTotal() {
        return userNumberTotal;
    }

    public void setUserNumberTotal(Integer userNumberTotal) {
        this.userNumberTotal = userNumberTotal;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

//    public String getQrcodeUrl() {
//        return qrcodeUrl;
//    }
//
//    public void setQrcodeUrl(String qrcodeUrl) {
//        this.qrcodeUrl = qrcodeUrl;
//    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Integer getQrcodeNumber() {
        return qrcodeNumber;
    }

    public void setQrcodeNumber(Integer qrcodeNumber) {
        this.qrcodeNumber = qrcodeNumber;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public String toString() {
        return "ListClassifyVO{" +
                "id=" + id +
                ", classify='" + classify + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", changeNumber=" + changeNumber +
                ", qrcodeNumber=" + qrcodeNumber +
                ", userNumberTotal=" + userNumberTotal +
                ", rank=" + rank +
                ", createdTime=" + createdTime +
                '}';
    }
}
