package com.pcloud.book.keywords.dao;

import com.pcloud.book.keywords.entity.BookGuideReply;
import com.pcloud.book.keywords.vo.ReplyMessageVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/23 16:06
 */
public interface BookGuideReplyDao extends BaseDao<BookGuideReply> {
    /**
     * @Author:lili
     * @Desr:删除回复消息
     * @Date:2019/4/23 16:26
     */
    void deleteByGuideId(Long bookGuideId);

    /**
     * @Author:lili
     * @Desr:获取引导语回复消息
     * @Date:2019/4/24 9:30
     */
    List<ReplyMessageVO> getReplyMessage(Long guideId);

    /**
     * @Author:lili
     * @Desr:更新应用基本信息
     * @Date:2019/6/6 11:33
     */
    void updateServeInfo(Long serveId, String serveType, String title, String squareImg);
}
