package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.SelfRobotKeywordDao;
import com.pcloud.book.keywords.dto.MaxSeqNAndBGDTO;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/30 11:39
 **/
@Component("selfRobotKeywordDao")
public class SelfRobotKeywordDaoImpl extends BaseDaoImpl<SelfRobotKeyword> implements SelfRobotKeywordDao {
    @Override
    public Integer batchInsert(List<SelfRobotKeyword> selfRobotKeywords) {
        return this.getSqlSession().insert(this.getStatement("batchInsert"), selfRobotKeywords);
    }

    @Override
    public void updateSelfRobotKeyword(SelfRobotKeyword selfRobotKeyword) {
        this.getSqlSession().update(this.getStatement("updateSelfRobotKeyword"), selfRobotKeyword);
    }

    @Override
    public void deleteByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        this.getSqlSession().delete(this.getStatement("deleteByBookGroupIds"), map);
    }

    @Override
    public List<SelfRobotKeyword> getListByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectList(this.getStatement("getListByBookGroupId"), map);
    }

    @Override
    public SelfRobotKeyword getByBookGroupIdAndKeyword(Long bookGroupId, String keyword) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        map.put("keyword", keyword);
        return this.getSqlSession().selectOne(this.getStatement("getByBookGroupIdAndKeyword"), map);
    }

    @Override
    public Integer getCountByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectOne(this.getStatement("getCountByBookGroupId"), map);
    }

    @Override
    public List<MaxSeqNAndBGDTO> getMaxSeqNumByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        return this.getSqlSession().selectList(this.getStatement("getMaxSeqNumByBookGroupIds"), map);
    }

    @Override
    public void updateSeqNum(Long id, Integer seqNum) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("seqNum", seqNum);
        this.getSqlSession().update(this.getStatement("updateSeqNum"), map);
    }

    @Override
    public List<String> getKeywords(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectList(this.getStatement("getKeywords"), map);
    }
}
