package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/5 20:51
 */
@Data
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookInfoAndAuthStatusDTO implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("图书名称")
    private String bookName;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("出版社")
    private String publish;

    @ApiModelProperty("是否删除")
    private Integer isDelete;

    @ApiModelProperty("书刊作者")
    private String author;

    @ApiModelProperty("授权后还需付费")
    private Integer isAuthorizedPay;
}
