package com.pcloud.book.copyright.service;

import com.pcloud.book.book.dto.BookAuthServeStatusParam;
import com.pcloud.book.copyright.dto.BookAuthServerDTO;
import com.pcloud.book.copyright.dto.QrcodeAuthServeDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 11:01
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAuthServeServiceCloud", path = "book/v1.0/bookAuthServeService")
@Api(description = "图书开启版权服务")
public interface BookAuthServeService {

    @ApiOperation(value = "批量获取应用是否开启版权保护", httpMethod = "POST")
    @RequestMapping(value = "/listIsOpen4ServeIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIds(@RequestBody BookAuthServeStatusParam bookAuthServeStatusParam)
            throws BizException;


    @ApiOperation(value = "批量获取应用是否开启版权保护", httpMethod = "POST")
    @RequestMapping(value = "/listIsOpen4ServeIdsAndQrcode", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIdsAndQrcode(@RequestBody QrcodeAuthServeDTO qrcodeAuthServeDTO)
            throws BizException;

    @ApiOperation(value = "获取应用是否开启版权保护", httpMethod = "POST")
    @PostMapping("listIsOpen4ServeIdsAndBookId")
    ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIdsAndBookId(@RequestBody BookAuthServerDTO bookAuthServerDTO)
            throws BizException;

    @ApiOperation(value = "获取应用是否开启授权后仍需付费", httpMethod = "POST")
    @PostMapping("listIsOpen4AuthorizedFree")
    ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4AuthorizedPay(@RequestBody BookAuthServerDTO bookAuthServerDTO)
            throws BizException;

}
