package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.entity.HotBookSale;
import com.pcloud.book.book.entity.HotBook;
import com.pcloud.common.page.PageBeanNew;

/**
 * 热门书名(HotBookSale)表服务接口
 *
 * @author makejava
 * @since 2020-10-14 12:06:59
 */
public interface HotBookSaleBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    HotBookSale getById(Integer id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param hotBookSale 实例对象
     * @return 主键
     */
    Integer insert(HotBookSale hotBookSale);

    /**
     * 修改数据
     *
     * @param hotBookSale 实例对象
     */
    void update(HotBookSale hotBookSale);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Integer id);

    PageBeanNew<HotBookSale> getHotBookList(Integer currentPage, Integer numPerPage);
}