package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletBookClassifyAgentDao;
import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.entity.AppletBookClassifyAgent;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletBookClassifyAgentDaoImpl
 * @Author zhuyajie
 * @Description
 * @Date 2020/7/17 16:51
 * @Version 1.0
 **/
@Component
public class AppletBookClassifyAgentDaoImpl extends BaseDaoImpl<AppletBookClassifyAgent> implements AppletBookClassifyAgentDao {
    @Override
    public void updateBaseInfoByAgent(AppletBookClassifyAgent appletBookClassifyAgent) {
        getSessionTemplate().update(getStatement("updateBaseInfoByAgent"), appletBookClassifyAgent);
    }

    @Override
    public List<AppletBookClassifyAgent> getByAgent(Long agentId) {
        return getSessionTemplate().selectList(getStatement("getByAgent"), agentId);
    }

    @Override
    public List<AppletBookClassifyDTO> listClassifyByAgent(Long agentId, Boolean showState) {
        Map<String,Object> map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("showState", showState);
        return getSessionTemplate().selectList(getStatement("listClassifyByAgent"), map);
    }
}
