package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.BuyBookRequestDao;
import com.pcloud.book.applet.dto.BuyBookRequestDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * (BuyBookRequest)表数据库访问层
 *
 * @author makejava
 * @since 2020-10-14 19:51:40
 */
@Repository("buyBookRequestDaoImpl")
public class BuyBookRequestDaoImpl extends BaseDaoImpl<BuyBookRequest> implements BuyBookRequestDao {

    @Override
    public List<BuyBookRequest> getUserCount() {
        return getSessionTemplate().selectList(getStatement("getUserCount"));
    }

    @Override
    public PageBeanNew getRequestByWechatUserIdAndState(Integer currentPage, Integer numPerPage, Map<String,Object> param) {
        return this.listPageNew(new PageParam(currentPage, numPerPage), param, "getRequestByWechatUserIdAndState");
    }

    @Override
    public List<Long> listIdsByWeChatUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("listIdsByWeChatUserId"));
    }

    @Override
    public List<Long> listAllWeChatUserId() {
        return getSessionTemplate().selectList(getStatement("listAllWeChatUserId"));
    }

    @Override
    public void update2ProcessingData(Map<String, Object> param) {
        this.getSessionTemplate().update(getStatement("update2ProcessingData"),param);
    }
}