/**
 * 
 */
package com.pcloud.book.book.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.pcloud.book.book.dao.BookProductDao;
import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.entity.BookProduct;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * @描述：书籍应用数据访问层接口实现类
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:57:10
 * @版本：1.0
 */
@Repository("bookProductDao")
public class BookProductDaoImpl extends BaseDaoImpl<BookProduct> implements BookProductDao {

	/**
	 * 删除作品应用关联关系
	 */
	@Override
	public long delete(BookProduct bookProduct) {
		return super.getSqlSession().delete(super.getStatement("delete"), bookProduct);
	}
	
	/**
	 * 删除作品应用关联关系
	 */
	@Override
	public long deleteByBook(Long bookId) {
		return super.getSqlSession().delete(super.getStatement("deleteByBook"), bookId);
	}

	/**
	 * 批量删除作品关联关系
	 */
	@Override
	public long deleteByBooks(List<Long> bookIds) {
		return super.getSqlSession().delete(super.getStatement("deleteByBooks"), bookIds);
	}
	
	/**
	 * 获取书籍关联的作品
	 */
	@Override
	public List<BookProductDto> getListById(BookProduct bookProduct) {
		return super.getSqlSession().selectList(super.getStatement("getListById"), bookProduct);
	}
	
	/**
	 * 根据书籍和渠道删除书籍商品关联信息
	 */
	@Override
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap) {
		
		return super.getSqlSession().delete(super.getStatement("deleteByBookAndChannel"), paramMap);
		
	}

	/**
	 * 获取书籍关联作品
	 */
	@Override
	public Map<Long, BookProductDto> getMapById(BookProduct bookProduct) {
		return super.getSqlSession().selectMap(this.getStatement("getMapById"), bookProduct,"productId");
	}

	/**
	 * 清除录音
	 */
	@Override
	public long cleanSound(Long videoId) {
		return super.getSqlSession().update(this.getStatement("cleanSound"),videoId);
	}

	/**
	 * 获取所有书籍关联作品
	 */
	@Override
	public List<BookProductDto> getAllBookProduct() {
		return super.getSqlSession().selectList(this.getStatement("getAllBookProduct"));
	}

	/**
	 * 批量更新商品類型
	 */
	@Override
	public void updateProductType(List<BookProductDto> allBookProduct) {
		super.getSqlSession().update(this.getStatement("updateProductType"),allBookProduct);
	}

	/**
	 * 获取与此录音相关联的书籍关联作品信息
	 */
	@Override
	public List<BookProductDto> listBySoundId(Long videoId) {
		return super.getSqlSession().selectList(this.getStatement("listBySoundId"),videoId);
	}
	
	/**
	 * 获取图书关联超级作者商品个数
	 */
	@Override
	public Integer getSuperProCount(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getSuperProCount"), paramMap);
	}
	
	/**
	 * 获取图书关联作者商品个数
	 */
	@Override
	public Integer getProCount(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getProCount"), paramMap);
	}
}
