package com.pcloud.book.book.facade.impl;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;


/**
 * ES同步Controller，开发人员初始化es数据使用
 */
@RestController
@RequestMapping(value = "applet/search")
public class AppletSearchSwitchController {

    private static final String KEY = "applet:book:search:v2";

    @GetMapping("switch")
    public ResponseDto<?> use(@RequestParam("use") Boolean use,
                              @RequestParam("time") Integer time) {
        if (Optional.ofNullable(use).orElse(false)) {
            int dur = Optional.ofNullable(time).orElse(5 * 60);
            JedisClusterUtils.set(KEY, "true", dur);
            return new ResponseDto<>("小程序图书搜索开始使用V2版本, 时长=" + (dur / 60) + "分钟");
        } else {
            JedisClusterUtils.del(KEY);
            return new ResponseDto<>("小程序图书搜索切回V1版本");
        }
    }

    public static boolean useV2Search() {
        return JedisClusterUtils.exists(KEY);
    }


}
