package com.pcloud.book.consumer.raystask;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.AdviserTaskQueueBiz;
import com.pcloud.common.core.dto.AdviserTaskDTO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.book.consumer.raystask.AdviserTaskConsr
 * @Author zhuyajie
 * @Description 编辑任务
 * @Date 2021/4/25 10:09
 * @Version 1.0
 **/
@Slf4j
@Component
public class AdviserTaskConsr {


    @Autowired
    private AdviserTaskQueueBiz adviserTaskQueueBiz;


   /**
    * 发送编辑任务queue
    */
    public void sendAdviserTaskQueue(Long adviserId, String targetType, Long targentId, String operateType) {
        log.info("发送编辑任务queue,adviserId={},targetType={},targentId={},operateType={}",adviserId,targetType,targentId,operateType);
        AdviserTaskDTO adviserTaskDTO = new AdviserTaskDTO();
        adviserTaskDTO.setAdviserId(adviserId);
        adviserTaskDTO.setTargetType(targetType);
        adviserTaskDTO.setTargetId(targentId);
        adviserTaskDTO.setTaskOperateType(operateType);
        adviserTaskQueueBiz.sendAdviserTaskQueue(adviserTaskDTO);
    }
}
