package com.pcloud.book.group.dao;

import com.pcloud.book.group.entity.ResourcePageColumn;
import com.pcloud.book.group.vo.ResourceColumnAndServeVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 自有码H5页面栏目(ResourcePageColumn)表数据库访问层
 *
 * @author makejava
 * @since 2021-03-26 15:26:02
 */
public interface ResourcePageColumnDao extends BaseDao<ResourcePageColumn> {


    /**
     * 最大排序值
     * @author：zhuyajie
     * @date：2021/3/29 13:45
     *  * @param null
     */
    Integer getMaxSeq(Long resourcePageId, Long navigationId);

    /**
     *栏目和资源列表
     * @author：zhuyajie
     * @date：2021/3/29 13:45
     *  * @param null
     */
    List<ResourceColumnAndServeVO> getColumnListByPageId(Long resourcePageId, Long navigationId);

    /**
     * 根据类型查询
     * @author：zhuyajie
     * @date：2021/4/2 10:28
     *  * @param null
     */
    List<ResourcePageColumn> getByColumnTypeAndPage(Long resourcePageId, Integer columnType);

    /**
     * 修改排序值
     * @author：zhuyajie
     * @date：2021/4/2 15:00
     *  * @param null
     */
    void updateColumnSeqNum(Long id, Integer columnSeq);

    /**
     * 查目标移动栏目
     * @author：zhuyajie
     * @date：2021/4/2 16:18
     *  * @param null
     */
    ResourcePageColumn getColumByMoveType(String moveType, Long resourcePageId, Integer columnSeq, Long navigationId);
    /**
     * 批量更新序号
     * @author：zhuyajie
     * @date：2021/4/14 10:36
     *  * @param null
     */
    void updateSeq4Batch(List<ResourceColumnAndServeVO> list);

    void deleteByPageId(Long resourcePageId);

    void updateNavigationId(Long navigationId, Long resourcePageId);

    List<ResourcePageColumn> getByNavigation(Long navigationId);
}