package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;

@JsonInclude(JsonInclude.Include.NON_NULL)
@ApiModel
@Data
public class BookServeResourceDTO implements Serializable {

    private static final long serialVersionUID = -4087382700500198821L;

    private Long bookId;

    private String bookName;

    private String bookCoverImg;

    private String agentName;

    private String author;

    private Object readerNum;

    private Object readerInfo;

    private Integer serverNum;

    private Long templetId;

    private String templetName;

    private Boolean isOpenAuth;

    private BigDecimal originalCost;

    private List<WechatMessageDTO> messages;

    @ApiModelProperty("公众号ID")
    private Long officialAccountsId;

    @ApiModelProperty("宣传语")
    private String slogan;

    @ApiModelProperty("总销售价")
    private BigDecimal totalPrice;

    @ApiModelProperty("折扣")
    private Double sale;

    @ApiModelProperty("折后价")
    private BigDecimal salePrice;

    @ApiModelProperty("短名称")
    private String shortTitle;

    @ApiModelProperty("是否开启活动")
    private Integer isOpen;

    @ApiModelProperty("授权状态")
    private Boolean authStatus;

    @ApiModelProperty("授权状态")
    private Long adviserId;

    @ApiModelProperty("渠道id")
    private Long channelId;

}
