package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.group.dto.NavigationParamDTO;
import com.pcloud.book.group.entity.ResourcePageCollect;
import com.pcloud.book.group.entity.ResourcePagePic;
import com.pcloud.book.group.entity.ResourceRecomManage;
import com.pcloud.book.group.vo.ResourcePageVO;
import com.pcloud.book.group.vo.UpdateResourceColumnVO;
import com.pcloud.book.group.vo.UpdateResourcePageVO;
import com.pcloud.channelcenter.qrcode.dto.BookSceneIdListDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import io.swagger.annotations.ApiOperation;

/**
 * @ClassName com.pcloud.book.group.facade.impl.ResourcePageFacade
 * @Author zhuyajie
 * @Description H5资源页配置
 * @Date 2021/3/29 10:41
 * @Version 1.0
 **/
@RestController
@RequestMapping("resourcePage")
public class ResourcePageFacade {
    @Autowired
    private ResourcePageBiz resourcePageBiz;

    @ApiOperation("更新资源页基本设置")
    @PostMapping("updateResourcePage")
    public ResponseDto<?> updateResourcePage(@RequestHeader("token") String token,
                                             @RequestBody @Validated UpdateResourcePageVO updateResourcePageVO) {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourcePageVO.setCreateUser(adviserId);
        return new ResponseDto<>(resourcePageBiz.updateResourcePage(updateResourcePageVO));
    }

    @ApiOperation("更新资源栏目设置")
    @PostMapping("updateResourceColumn")
    public ResponseDto<?> updateResourceColumn(@RequestHeader("token") String token,
                                               @RequestBody @Validated UpdateResourceColumnVO updateResourceColumnVO){
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourceColumnVO.setCreateUser(adviserId);
        resourcePageBiz.updateResourceColumn(updateResourceColumnVO);
        return new ResponseDto<>();
    }

    @ApiOperation("根据rays码id查资源页基本配置")
    @GetMapping("getResourcePageByBookGroupId")
    public ResponseDto<?> getResourcePageByBookGroupId(@RequestHeader("token") String token,
                                                       @RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                                       @RequestParam(value = "sceneId", required = false) Long sceneId){
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookGroupIdOrSceneId(bookGroupId, adviserId, sceneId));
    }

    @ApiOperation("编辑端-根据页面id查资源页栏目及资源")
    @GetMapping("getColumnAndServeListByPageId")
    public ResponseDto<?> getColumnAndServeListByPageId(@RequestHeader("token") String token,
                                                        @RequestParam("resourcePageId") Long resourcePageId,
                                                        @RequestParam(value = "navigationId", required = false) Long navigationId){
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeListByPageId(resourcePageId, false, null, null, null, null, navigationId));
    }

    @ApiOperation("客户端-根据书刊查资源页基本配置")
    @GetMapping("getResourcePageByBookId4Wechat")
    public ResponseDto<?> getResourcePageByBookId4Wechat(@CookieValue("userInfo") String userInfo,
                                                         @RequestParam("bookId") Long bookId,
                                                         @RequestParam("channelId") Long channelId,
                                                         @RequestParam("adviserId") Long adviserId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookId(bookId, channelId, adviserId, wechatUserId));
    }

    @ApiOperation("客户端-根据页面id查资源页栏目及资源")
    @GetMapping("getColumnAndServeListByPageId4Wechat")
    public ResponseDto<?> getColumnAndServeListByPageId4Wechat(@CookieValue("userInfo") String userInfo,
                                                                @RequestParam("resourcePageId") Long resourcePageId,
                                                               @RequestParam(value = "bookId", required = false) Long bookId,
                                                               @RequestParam(value = "adviserId", required = false) Long adviserId,
                                                               @RequestParam(value = "channelId", required = false) Long channelId,
                                                               @RequestParam(value = "enableAdverting", required = false) Integer enableAdverting,
                                                               @RequestParam(value = "navigationId", required = false) Long navigationId){
        Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeListByPageId(resourcePageId, true, bookId, adviserId, channelId, enableAdverting, navigationId));
    }

    @ApiOperation("客户端分页查栏目资源")
    @GetMapping("listPageResourcePageItem")
    public ResponseDto<?> listPageResourcePageItem(@CookieValue("userInfo") String userInfo,
                                                   @RequestParam("currentPage") Integer currentPage,
                                                   @RequestParam("numPerPage") Integer numPerPage,
                                                   @RequestParam("resourcePageColumnId") Long resourcePageColumnId) {
        Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.listPageResourcePageItem(currentPage, numPerPage, resourcePageColumnId));
    }

    @ApiOperation("获取栏目及资源类型")
    @GetMapping("getColumnAndServeTypeList")
    public ResponseDto<?> getColumnAndServeTypeList() {
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeTypeList());
    }

    @ApiOperation("编辑端-栏目上移下移")
    @GetMapping("updateColumnSeq")
    public ResponseDto<?> updateColumnSeq(@RequestHeader("token") String token,
                                          @RequestParam("resourcePageColumnId") Long resourcePageColumnId,
                                          @RequestParam("moveType") String moveType) {
        SessionUtil.getToken4Redis(token);
        resourcePageBiz.updateColumnSeq(resourcePageColumnId, moveType);
        return new ResponseDto<>();
    }

    @ApiOperation("编辑端-删除栏目")
    @GetMapping("deleteColumnById")
    public ResponseDto<?> deleteColumnById(@RequestHeader("token") String token,
                                           @RequestParam("resourcePageColumnId") Long resourcePageColumnId) {
        SessionUtil.getToken4Redis(token);
        resourcePageBiz.deleteColumnById(resourcePageColumnId);
        return new ResponseDto<>();
    }

    @ApiOperation("更新资源页和栏目设置")
    @PostMapping("updateResourcePageAndColumn")
    public ResponseDto<?> updateResourcePageAndColumn(@RequestHeader("token") String token,
                                             @RequestBody @Validated UpdateResourcePageVO updateResourcePageVO) {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourcePageVO.setCreateUser(adviserId);
        return new ResponseDto<>(resourcePageBiz.updateResourcePageAndColumn(updateResourcePageVO));
    }

    @ApiOperation("客户端-根据rays码id查资源页基本配置")
    @GetMapping("getResourcePageByBookGroupId4Wechat")
    public ResponseDto<?> getResourcePageByBookGroupId4Wechat(@CookieValue("userInfo") String userInfo,
                                                              @RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                                              @RequestParam(value = "sceneId", required = false) Long sceneId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookGroupIdOrSceneId4Wechat(bookGroupId, wechatUserId, sceneId));
    }

    @ApiOperation("批量更新资源页应用作品链接")
    @PostMapping("batchUpdateResourceUrl")
    public ResponseDto<?> batchUpdateResourceUrl(@RequestBody List<Long> sceneIdList) {
        resourcePageBiz.batchUpdateResourceUrl(sceneIdList);
        return new ResponseDto<>();
    }

    @ApiOperation("是否只有一个资源")
    @GetMapping("hasOneResource")
    public ResponseDto<?> hasOneResource(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                          @RequestParam(value = "sceneId", required = false) Long sceneId) {
        return new ResponseDto<>(resourcePageBiz.hasOneResource(bookGroupId, sceneId));
    }

    @ApiOperation("添加收藏记录")
    @PostMapping("addCollectRecord")
    public ResponseDto<?> addCollectRecord(@CookieValue("userInfo") String userInfo, @RequestBody ResourcePageCollect resourcePageCollect) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        resourcePageCollect.setWechatUserId(wechatUserId);
        resourcePageCollect.setOfficialAccountsId(officialAccountsId);
        resourcePageBiz.addCollectRecord(resourcePageCollect);
        return new ResponseDto<>();
    }

    @ApiOperation("更新书刊id")
    @PostMapping("batchUpdateBookId")
    public ResponseDto<?> batchUpdateBookId(@RequestBody List<BookSceneIdListDTO> requestDto) {
        resourcePageBiz.batchUpdateBookId(requestDto);
        return new ResponseDto<>();
    }

    @ApiOperation("查H5资源页工具")
    @GetMapping("getToolListByUser")
    public ResponseDto<?> getToolListByUser(@CookieValue("userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(resourcePageBiz.getToolListByUser(wechatUserId, officialAccountsId));
    }

    @ApiOperation("资源广场模块")
    @GetMapping("getResourceSourceTypeList")
    public ResponseDto<?> getResourceSourceTypeList(@CookieValue("userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(resourcePageBiz.getResourceSourceTypeList(wechatUserId, officialAccountsId));
    }

    @ApiOperation("添加课程统计数据")
    @GetMapping("insertCourseStatistic")
    public ResponseDto<?> insertCourseStatistic() {
        resourcePageBiz.insertCourseStatistic();
        return new ResponseDto<>();
    }

    @ApiOperation("H5首页-根据用户年级查推荐课程")
    @GetMapping("listCourseByUser")
    public ResponseDto<?> listCourseByUser(@CookieValue("userInfo") String userInfo,
                                                   @RequestParam("currentPage") Integer currentPage,
                                                   @RequestParam("numPerPage") Integer numPerPage) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(resourcePageBiz.listCourseByUser(wechatUserId, officialAccountsId, currentPage, numPerPage));
    }


    @ApiOperation("获取用户H5新用户状态")
    @GetMapping("getUserNewState")
    public ResponseDto<?> getUserNewState(@CookieValue("userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getUserNewState(wechatUserId));
    }

    @ApiOperation("添加非新用户记录")
    @PostMapping("addNewUserRecord")
    public ResponseDto<?> addNewUserRecord(@CookieValue("userInfo") String userInfo, @RequestBody ResourcePageCollect resourcePageCollect) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        resourcePageCollect.setWechatUserId(wechatUserId);
        resourcePageCollect.setOfficialAccountsId(officialAccountsId);
        resourcePageBiz.addNewUserRecord(resourcePageCollect);
        return new ResponseDto<>();
    }

    @ApiOperation("获取所有开启“轻工-世间食记”的书刊")
    @GetMapping("getAllBook4OpenFood")
    public ResponseDto<List<ResourcePageVO>> getAllBook4OpenFood(){
        return new ResponseDto<>(resourcePageBiz.getAllBook4OpenFood());
    }

    @ApiOperation("是否配置有使用付费公众号工具的应用")
    @GetMapping("hasOfficialAccountsTool")
    public ResponseDto<?> hasOfficialAccountsTool(@CookieValue("userInfo") String userInfo, @RequestParam("resourcePageId") Long resourcePageId) {
        Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.hasOfficialAccountsTool(resourcePageId));
    }


    @ApiOperation("平台端-资源推荐管理-热门课程")
    @GetMapping("listRecommendCourse4Pcloud")
    public ResponseDto<?> listRecommendCourse4Pcloud(@RequestHeader("token") String token,
                                                     @RequestParam("currentPage") Integer currentPage,
                                                     @RequestParam("numPerPage") Integer numPerPage,
                                                     @RequestParam(value = "query", required = false) String query) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(resourcePageBiz.listRecommendCourse4Pcloud(currentPage, numPerPage, query));
    }

    @ApiOperation("平台端-资源推荐管理-教辅、育儿宝库")
    @GetMapping("listRecommendResource4Pcloud")
    public ResponseDto<?> listRecommendResource4Pcloud(@RequestHeader("token") String token,
                                                       @RequestParam("currentPage") Integer currentPage,
                                                       @RequestParam("numPerPage") Integer numPerPage,
                                                       @RequestParam(value = "query", required = false) String query,
                                                       @RequestParam("sourceFrom") Integer sourceFrom) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(resourcePageBiz.listRecommendResource4Pcloud(currentPage, numPerPage, query, sourceFrom));
    }

    @ApiOperation("平台端-资源推荐管理-修改")
    @PostMapping("updateRecommendResource4Pcloud")
    public ResponseDto<?> updateRecommendResource4Pcloud(@RequestHeader("token") String token,
                                                         @RequestBody ResourceRecomManage resourceRecomManage) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        resourceRecomManage.setCreateUser(partyId);
        resourcePageBiz.updateRecommendResource4Pcloud(resourceRecomManage);
        return new ResponseDto<>();
    }

    @ApiOperation("处理旧数据导航")
    @GetMapping("dealOldNavigation")
    public ResponseDto<?> dealOldNavigation() {
        resourcePageBiz.dealOldNavigation();
        return new ResponseDto<>();
    }

    @ApiOperation("保存导航")
    @PostMapping("saveNavigation")
    public ResponseDto<?> saveNavigation(@RequestHeader("token") String token,
                                        @RequestBody NavigationParamDTO navigationParamDTO) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        navigationParamDTO.setCreateUser(partyId);
        resourcePageBiz.saveNavigation(navigationParamDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("添加导航图片到图片库")
    @PostMapping("addNavigationPic")
    public ResponseDto<?> addNavigationPic(@RequestHeader("token") String token,
                                           @RequestBody ResourcePagePic resourcePagePic) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        resourcePagePic.setAdviserId(partyId);
        resourcePageBiz.addNavigationPic(resourcePagePic);
        return new ResponseDto<>();
    }

    @ApiOperation("删除导航图片库图片")
    @GetMapping("deleteNavigationPic")
    public ResponseDto<?> deleteNavigationPic(@RequestHeader("token") String token,
                                              @RequestParam("id") Long id) {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        resourcePageBiz.deleteNavigationPic(id);
        return new ResponseDto<>();
    }

    @ApiOperation("查询导航图片库图片")
    @GetMapping("listNavigationPic")
    public ResponseDto<?> listNavigationPic(@RequestHeader("token") String token,
                                            @RequestParam("currentPage") Integer currentPage,
                                            @RequestParam("numPerPage") Integer numPerPage) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(resourcePageBiz.listNavigationPic(partyId, currentPage, numPerPage));
    }

    @ApiOperation("栏目重新排序")
    @PostMapping("batchUpdateColumnSeq")
    public ResponseDto<?> batchUpdateColumnSeq(@RequestBody List<Long> navigationIds) {
        resourcePageBiz.batchUpdateColumnSeq(navigationIds);
        return new ResponseDto<>();
    }
}
