package com.pcloud.book.group.vo;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.book.book.vo.BookLinkVO;
import com.pcloud.book.book.vo.response.BookQrcodeWxworkResponseVO;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.wechatgroup.wxwork.dto.WxworkGroupQrcodeBaseDTO;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.vo.ResourcePageItemVO
 * @Author zhuyajie
 * @Description 资源页栏目详情
 * @Date 2021/3/26 17:21
 * @Version 1.0
 **/
@Data
public class ResourcePageItemVO extends BaseDto{

    private Long id;

    private Long resourcePageColumnId;
    /**
     * 资源id
     */
    private Long serveId;
    /**
     * 资源类型
     */
    private String serveType;
    /**
     * 链接url
     */
    private String linkUrl;
    /**
     * 资源类型
     */
    private String typeCode;
    /**
     * 排序值
     */
    private Integer seqNum;
    /**
     * 二维码引导关注文案
     */
    private String guideContent;
    /**
     * 二维码logo链接/图片位图片
     */
    private String logoUrl;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 书刊链接来源（1当当2京东3拼多多）
     */
    private Integer linkFrom;

    /**
     * 二维码来源
     */
    private Integer qrcodeSource;

    /**资源其他信息**/

    private String serveName;
    private String servePic;
    private String typeName;
    private String transverseImg;
    private Double price;
    @ApiModelProperty("跳转结果链接")
    private String resultUrl;

    private String isbn;
    private String bookName;
    private String coverImg;
    private String uniqueNumber;
    private String publish;
    @ApiModelProperty("商品应用中有第三方链接")
    private Boolean hasThirdLink;

    private Long channelId;

    @ApiModelProperty("书单")
    private AppletOuterBooklistDTO appletOuterBooklistDTO;
    @ApiModelProperty("社群")
    private GroupActivity4AppletDTO activity4AppletDTO;
    @ApiModelProperty("第三方资源")
    private AppletThirdResources appletThirdResources;
    @ApiModelProperty("企业微信群")
    private BookQrcodeWxworkResponseVO bookQrcodeWxworkResponseVO;

    private Long sceneId;

    @ApiModelProperty("是否配置了公众号工具")
    private Boolean hasOfficialAccountsTool;

    private String qrcodeType;

    private Integer jumpType;
}
