package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;

import lombok.Data;

/**
 * 权益也弹出记录(RightsNowPopup)实体类
 *
 * @author makejava
 * @since 2020-09-16 10:30:07
 */
@Data
public class RightsNowPopup extends BaseEntity {
    private static final long serialVersionUID = -29622792648706099L;
    /**
    * 用户id
    */
    private Long wechatUserId;
    /**
    * 书刊id
    */
    private Long bookId;
    /**
    * 渠道id
    */
    private Long channelId;
    /**
    * 编辑id
    */
    private Long adviserId;
    /**
    * 权益id
    */
    private Long rightsSettingId;
    /**
    * 弹出类型（1配套资料2线上网课服务）
    */
    private Integer popupType;
    /**
    * 资源id
    */
    private Long serveId;
    /**
    * 资源类型APP/PRODUCT/NEWS
    */
    private String serveType;
    /**
    * 记录类型（1弹出2点击领取3关闭）
    */
    private Integer recordType;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
    * 修改时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    /**
     * 阅读类型
     */
    private Integer readType;
    /**
     * 弹窗来源资源id
     */
    private Long baseServeId;
    /**
     * 弹窗来源资源类型APP/PRODUCT
     */
    private String baseServeType;

}