package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingGroupTag;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：群标记广告主
 * @作者：zhuyajie
 * @创建时间：14:52 2019/8/21
 * @版本：1.0
 */
public interface AdvertisingGroupTagDao extends BaseDao<AdvertisingGroupTag> {

    /**
     * 根据广告主删除
     * @param masterId
     */
    public void deleteByMasterId(Long masterId);

    /**
     * 已标记的书
     * @param masterId
     * @return
     */
    public List<Long> getBookIdsByMasterId(Long masterId);

    /**
     * 根据群删除标记
     * @param groupQrcodeId
     */
    public void deleteByGroupQrcodeId(Long groupQrcodeId);

    /**
     * 已标记的群
     * @param masterId
     * @return
     */
    public List<Long> getGroupQrcodeIdsByMasterId(Long masterId);

    /**
     * 根据图书删除标记
     * @param bookIds
     * @param masterId
     */
    void deleteByBook(List<Long> bookIds, Long masterId);

    /**
     * 查已标记的微信群id
     * @param masterId
     * @return
     */
    List<String> getTagWxGroupIdsByMasterId(Long masterId);

    /**
     * 根据书查标记的广告主
     * @param bookId
     * @return
     */
    List<Long> getMasterIdsByBookId(Long bookId);
}
