package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.WechatGroupClickUserDTO;
import com.pcloud.book.advertising.entity.AdvertisingClickRecord;
import com.pcloud.book.advertising.entity.AdvertisingPilotRecord;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Description 广告位点击记录数据访问层接口
 * @author PENG
 * @date 2019/2/28
 */
public interface AdvertisingPilotRecordDao extends BaseDao<AdvertisingPilotRecord> {



    /**
     * 获得试听人数
     * @param masterId
     * @return
     */
    public Long getPilotUserNumByMasterId(Long masterId);

    /**
     * 微信群完课量
     * @param qrcodeId
     * @param adId
     * @param statisMonth
     * @return
     */
    Long getPilotUserNumByQrcode(Long qrcodeId, Long adId, String statisMonth);

    /**
     * 广告位完课量
     * @param adId
     * @param bookId
     * @param adviserId
     * @param channelId
     * @param statisMonth
     * @return
     */
    Long getPilotUserNumByAdId(Long adId, Long bookId, Long adviserId, Long channelId, String statisMonth);

    /**
     * 书刊完课量
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    Long getPilotUserNumByBookId(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth);
}
