package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingDetailFileDao;
import com.pcloud.book.advertising.entity.AdvertisingDetailFile;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：广告详情上传文件
 * @作者：zhuyajie
 * @创建时间：21:17 2019/8/2
 * @版本：1.0
 */
@Component("advertisingDetailFileDao")
public class AdvertisingDetailFileDaoImpl extends BaseDaoImpl<AdvertisingDetailFile> implements AdvertisingDetailFileDao {

    @Override
    public List<AdvertisingDetailFile> getByAdId(Long adId) {
        return getSessionTemplate().selectList(getStatement("getByAdId"), adId);
    }

    @Override
    public void deleteByAdId(Long adId) {
        getSessionTemplate().delete(getStatement("deleteByAdId"), adId);
    }
}
