package com.pcloud.book.clock.dao;

import com.pcloud.book.clock.dto.BookGroupClockDTO;
import com.pcloud.book.clock.entity.BookGroupClock;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:51
 * @Version 1.0
 */
public interface BookGroupClockDao extends BaseDao<BookGroupClock> {

    /**
     * 批量插入
     * @param bookGroupClockList
     */
    void batchInsert(List<BookGroupClock> bookGroupClockList);

    /**
     * 删除关联的社群书
     * @param paramMap
     */
    void deleteBookGroupId4AppType(Map<String,Object> paramMap);

    /**
     * 删除关联的社群码
     * @param paramMap
     */
    void deleteClassifyId4AppType(Map<String,Object> paramMap);

    /**
     * 获取关联的社群码
     * @param paramMap
     * @return
     */
    List<BookGroupClockDTO> getBookGroupClockIds(Map<String,Object> paramMap);

    /**
     * 删除该作品/应用已关联的书下面的分类
     * @param paramMap
     */
    void deleteClassifyIdByBookGroupIds(Map<String,Object> paramMap);

    /**
     * 校验群是否为微信群打卡的群
     * @param paramMap
     * @return
     */
    List<Long> getInfoIdByWeixinGroupId(Map<String,Object> paramMap);

    /**
     * 获取微信群打卡基本信息
     * @param bookClockInfoIds
     * @return
     */
    List<BookGroupClockDTO> getInfoByInfoIds(List<Long> bookClockInfoIds);

    /**
     * 取消关联
     * @param paramMap
     */
    void cancelSelected(Map<String,Object> paramMap);

    /**
     * 删除对应关联的书及分类
     * @param paramMap
     */
    void deleteBookGroupClock(Map<String,Object> paramMap);

    List<Long> getClassifyIdsByBookGroupId(Long bookClockInfoId);

    List<Long> getClassifyIdsByClassfyId(Long bookClockInfoId);
}
