/**
 * 
 */
package com.pcloud.book.consumer.analysisengine;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.analysisengine.qrcode.dto.BookTimeSourceDto;
import com.pcloud.analysisengine.qrcode.service.SceneRecordService;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * @描述：二维码记录中间件
 * @作者：songx
 * @创建时间：2016年12月14日,下午5:36:04 @版本：1.0
 */
@Component("sceneRecordConsr")
public class SceneRecordConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(SceneRecordConsr.class);

	@Autowired
	private SceneRecordService sceneRecordService;

	/**
	 * 获取第一次扫描时间
	 */
	public BookTimeSourceDto getBookScanInfo(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】 获取第一次扫描时间,<PARAM>.[bookId]=" + bookId + ",[channelId]=" + channelId + ",[adviserId]="
				+ adviserId);
		if (bookId == null || channelId == null || adviserId == null) {
			return null;
		}

		BookTimeSourceDto bookTimeSourceDto = null;
		try {
			bookTimeSourceDto = ResponseHandleUtil.parseResponse(
					sceneRecordService.getBookScanInfo(bookId, channelId, adviserId), BookTimeSourceDto.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取第一次扫描时间,<ERROR>.[getBookScanInfo]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】获取第一次扫描时间,<ERROR>.[getBookScanInfo]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取第一次扫描时间失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】获取第一次扫描时间,<END>");
		return bookTimeSourceDto;
	}
}
