/**
 * 
 */
package com.pcloud.book.consumer.label;

import com.pcloud.common.core.biz.LabelUsedQueueBiz;
import com.pcloud.common.core.dto.LabelUsedMessageDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.labelcenter.label.service.LabelService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @描述：标签中间件
 * @作者：songx
 * @创建时间：2016年12月21日,下午3:04:17 @版本：1.0
 */
@Slf4j
@Component("labelConsr")
public class LabelConsr {


	@Autowired
	private LabelService labelService;
	@Autowired
	private LabelUsedQueueBiz labelUsedQueueBiz;

	/**
	 * 标签使用量
	 */
	public void sendLabelUsed(Long partyId, Long proLabelId, Long depLabelId, Long purLabelId) throws BizException {
		log.info("【标签中心(消)】标签使用量,<START>.[partyId]=" + partyId + ",[proLabelId]=" + proLabelId + ",[depLabelId]="
				+ depLabelId + ",[purLabelId]=" + purLabelId);
		if (proLabelId == null && depLabelId == null && purLabelId == null) {
			return;
		}
		LabelUsedMessageDto labelUsedMessageDto = new LabelUsedMessageDto(partyId, proLabelId, depLabelId, purLabelId);
		try {
			labelUsedQueueBiz.sendMessageQueue(labelUsedMessageDto);
		} catch (Exception e) {
			log.error("【标签中心(消)】标签使用量.[sendMessageQueue]:" + e.getMessage(), e);
		}
		log.info("【标签中心(消)】标签使用量,<END>");
	}

	/**
	 * 获取标签的名称
	 */
	public Map<Long, String> getLabelName(List<Long> labelIds) throws BizException {
		log.info("【标签中心(消)】获取标签的名称,<START>.[labelIds]=" + labelIds.toString());
		if (ListUtils.isEmpty(labelIds)) {
			return null;
		}
		Map<Long, String> labelNameMap = null;
		try {
			labelNameMap = ResponseHandleUtil.parseMap(labelService.getLabelName(labelIds), Long.class, String.class);
		} catch (Exception e) {
			log.error("【标签中心(消)】获取标签的名称.[getLabelName]:" + e.getMessage(), e);
		}
		log.info("【标签中心(消)】获取标签的名称,<END>.[labelNameMap]=" + (labelNameMap == null ? null : labelNameMap.toString()));
		return labelNameMap;
	}

	/**
	 * 根据标签名称获取标签id
	 */
	public Long getLabelIdByName(Long partyId, String code, String labelName, Long parentLabelId) {
		log.info("【标签中心(消)】根据标签名称获取标签id,<START>.[partyId]=" + partyId + ",[code]=" + code + ",[labelName]="
				+ labelName + ",[parentLabelId]=" + parentLabelId);
		if (parentLabelId == null) {
			return null;
		}
		Long labelId = null;
		try {
			labelId = ResponseHandleUtil
					.parseResponse(labelService.getLableIdByName(partyId, code, labelName, parentLabelId), Long.class);
		} catch (Exception e) {
			log.error("【标签中心(消)】根据标签名称获取标签id.[getLableIdByName]:" + e.getMessage(), e);
		}
		log.info("【标签中心(消)】根据标签名称获取标签id,<START>.[labelId]=" + labelId);
		return labelId;
	}
}
